<?php

class DSM_Mega_Menu extends ET_Builder_Module {
	public $slug       = 'dsm_mega_menu';
	public $vb_support = 'on';

	protected $module_credits = array(
		'module_uri' => 'https://divisupreme.com/',
		'author'     => 'Divi Supreme',
		'author_uri' => 'https://divisupreme.com/',
	);

	public function init() {
		$this->name            = esc_html__( 'Supreme Mega Menu', 'supreme-mega-menu' );
		$this->child_slug      = 'dsm_mega_menu_child';
		$this->child_item_text = esc_html__( 'Mega Menu Item', 'supreme-mega-menu' );
		$this->icon_path       = plugin_dir_path( __FILE__ ) . 'icon.svg';

		$this->settings_modal_toggles = array(
			'general'    => array(
				'toggles' => array(
					'main_content'       => esc_html__( 'General', 'supreme-mega-menu' ),
					'dsm_logo_panel'     => esc_html__( 'Logo', 'supreme-mega-menu' ),
					'dsm_dropdown_panel' => esc_html__( 'Dropdown', 'supreme-mega-menu' ),
					'dsm_element_panel'  => esc_html__( 'Elements', 'supreme-mega-menu' ),
				),
			),
			'advanced'   => array(
				'toggles' => array(
					'dsm_alignment_panel'         => esc_html__( 'Alignment', 'supreme-mega-menu' ),
					'dsm_menu_panel'              => esc_html__( 'Menu', 'supreme-mega-menu' ),
					'dsm_logo_panel'              => esc_html__( 'Logo', 'supreme-mega-menu' ),
					'dsm_menu_container_panel'    => esc_html__( 'Vertical Menu Container', 'supreme-mega-menu' ),
					'dsm_badge_panel'             => esc_html__( 'Badge', 'supreme-mega-menu' ),
					'dsm_submenu_panel'           => esc_html__( 'Sub Menu Text', 'supreme-mega-menu' ),
					'dsm_dropdown_panel'          => esc_html__( 'Dropdown', 'supreme-mega-menu' ),
					'dsm_cart_panel'              => esc_html__( 'Cart Count', 'supreme-mega-menu' ),
					'dsm_image_icon_panel'        => esc_html__( 'Image & Icon', 'supreme-mega-menu' ),
					'dsm_search_icon_panel'       => esc_html__( 'Search Icon', 'supreme-mega-menu' ),
					'dsm_search_field_panel'      => esc_html__( 'Search Field', 'supreme-mega-menu' ),
					'dsm_arrow_panel'             => esc_html__( 'Arrow', 'supreme-mega-menu' ),
					'dsm_hamburger_panel'         => esc_html__( 'Hamburger', 'supreme-mega-menu' ),
					'dsm_mobile_container_panel'  => esc_html__( 'Tablet/Mobile Container', 'supreme-mega-menu' ),
					'dsm_mobile_close_icon_panel' => esc_html__( 'Tablet/Mobile Close Icon', 'supreme-mega-menu' ),
				),
			),
			'custom_css' => array(
				'toggles' => array(
					'animation'  => array(
						'title'    => esc_html__( 'Animation', 'supreme-mega-menu' ),
						'priority' => 90,
					),
					'attributes' => array(
						'title'    => esc_html__( 'Attributes', 'supreme-mega-menu' ),
						'priority' => 95,
					),
				),
			),
		);
	}

	public function get_advanced_fields_config() {
		return array(
			'fonts'      => array(
				'dsm_menu_text'         => array(
					'label'           => esc_html__( 'Menu Text', 'supreme-mega-menu' ),
					'css'             => array(
						'main' => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-menu-text',
					),

					'font_size'       => array(
						'default' => '14px',
					),

					'line_height'     => array(
						'default' => '1.7em',
					),

					'letter_spacing'  => array(
						'default' => '0px',
					),

					'hide_text_color' => true,

					'tab_slug'        => 'advanced',
					'toggle_slug'     => 'dsm_menu_panel',
				),

				'dsm_menu_badge_text'   => array(
					'label'           => esc_html__( 'Badge Text', 'supreme-mega-menu' ),
					'css'             => array(
						'main' => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-badge-text',
					),

					'font_size'       => array(
						'default' => '14px',
					),

					'line_height'     => array(
						'default' => '1em',
					),

					'letter_spacing'  => array(
						'default' => '0px',
					),

					'hide_text_color' => true,

					'tab_slug'        => 'advanced',
					'toggle_slug'     => 'dsm_badge_panel',
				),

				'dsm_submenu_text'      => array(
					'label'           => esc_html__( 'Sub Menu Text', 'supreme-mega-menu' ),
					'css'             => array(
						'main' => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container a',
					),

					'font_size'       => array(
						'default' => '14px',
					),

					'line_height'     => array(
						'default' => '1.7em',
					),

					'letter_spacing'  => array(
						'default' => '0px',
					),

					'hide_text_color' => true,

					'tab_slug'        => 'advanced',
					'toggle_slug'     => 'dsm_submenu_panel',
				),

				'dsm_cart_count_text'   => array(
					'label'           => esc_html__( 'Cart Count Text', 'supreme-mega-menu' ),
					'css'             => array(
						'main' => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					),

					'font_size'       => array(
						'default' => '14px',
					),

					'line_height'     => array(
						'default' => '1.7em',
					),

					'letter_spacing'  => array(
						'default' => '0px',
					),

					'hide_text_color' => true,

					'tab_slug'        => 'advanced',
					'toggle_slug'     => 'dsm_cart_panel',
				),

				'dsm_search_field_text' => array(
					'label'           => esc_html__( 'Search Text', 'supreme-mega-menu' ),
					'css'             => array(
						'main'      => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
						'important' => 'all',
					),

					'font_size'       => array(
						'default' => '14px',
					),

					'line_height'     => array(
						'default' => '1.7em',
					),

					'letter_spacing'  => array(
						'default' => '0px',
					),

					'hide_text_color' => true,

					'tab_slug'        => 'advanced',
					'toggle_slug'     => 'dsm_search_field_panel',
				),
			),

			'box_shadow' => array(
				'default'                        => array(
					'css' => array(
						'main' => '%%order_class%%',
					),
				),

				'dsm_menu_item_shadow'           => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_menu_panel',
				),

				'dsm_badge_item_shadow'          => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-badge-text',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_badge_panel',
				),

				'dsm_dropdown_shadow'            => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-submenu-container .dsm-submenu-inner-container',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_dropdown_panel',
				),

				'dsm_submenu_shadow'             => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu ul li',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_submenu_panel',
				),

				'dsm_cart_shadow'                => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_cart_panel',
				),

				'dsm_image_icon_shadow'          => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_image_icon_panel',
				),

				'dsm_search_icon_shadow'         => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_search_icon_panel',
				),

				'dsm_search_field_shadow'        => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_search_field_panel',
				),

				'dsm_menu_item_container_shadow' => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-mega-menu-container.dsm-mega-menu-vertical-layout .dsm-root-menu',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_menu_container_panel',
				),

				'dsm_hamburger_icon_shadow'      => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-mobile-menu-open-button-container .dsm-mega-menu-open-button',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_hamburger_panel',
				),

				'dsm_mobile_container_shadow'    => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_mobile_container_panel',
				),

				'dsm_mobile_close_icon_shadow'   => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-close-button',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_mobile_close_icon_panel',
				),

				'dsm_logo_shadow'                => array(
					'css'         => array(
						'main' => '%%order_class%% .dsm-mega-menu-container .dsm-logo-wrap img, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-wrap img',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_logo_panel',
				),
			),

			'borders'    => array(
				'default'                        => array(
					'css' => array(
						'main' => '%%order_class%%',
					),
				),

				'dsm_menu_item_border'           => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link',
							'border_styles' => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_menu_panel',
				),

				'dsm_badge_item_border'          => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-badge-text',
							'border_styles' => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-badge-text',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_badge_panel',
				),

				'dsm_dropdown_border'            => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-submenu-container .dsm-submenu-inner-container',
							'border_styles' => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-submenu-container .dsm-submenu-inner-container',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_dropdown_panel',
				),

				'dsm_submenu_border'             => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu ul li',
							'border_styles' => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu ul li',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_submenu_panel',
				),

				'dsm_cart_border'                => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
							'border_styles' => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_cart_panel',
				),

				'dsm_image_icon_border'          => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
							'border_styles' => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_image_icon_panel',
				),

				'dsm_search_icon_border'         => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
							'border_styles' => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_search_icon_panel',
				),

				'dsm_search_field_border'        => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
							'border_styles' => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_search_field_panel',
				),

				'dsm_menu_item_container_border' => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-mega-menu-container.dsm-mega-menu-vertical-layout .dsm-root-menu',
							'border_styles' => '%%order_class%% .dsm-mega-menu-container.dsm-mega-menu-vertical-layout .dsm-root-menu',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_menu_container_panel',
				),

				'dsm_hamburger_icon_border'      => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-mobile-menu-open-button-container .dsm-mega-menu-open-button',
							'border_styles' => '%%order_class%% .dsm-mobile-menu-open-button-container .dsm-mega-menu-open-button',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_hamburger_panel',
				),

				'dsm_mobile_container_border'    => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
							'border_styles' => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_mobile_container_panel',
				),

				'dsm_mobile_close_icon_border'   => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-close-button',
							'border_styles' => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-close-button',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_mobile_close_icon_panel',
				),

				'dsm_logo_border'                => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .dsm-mega-menu-container .dsm-logo-wrap img, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-wrap img',
							'border_styles' => '%%order_class%% .dsm-mega-menu-container .dsm-logo-wrap img, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-wrap img',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_logo_panel',
				),
			),

			'text'       => false,
			'filters'    => false,
			'transform'  => false,
		);
	}

	public function get_fields() {

		$dsm_animation_list = array(
			'none'              => esc_html__( 'None', 'supreme-mega-menu' ),
			'fadeIn'            => esc_html__( 'Fade In', 'supreme-mega-menu' ),
			'fadeInDown'        => esc_html__( 'Fade In Down', 'supreme-mega-menu' ),
			'fadeInDownBig'     => esc_html__( 'Fade In Down Big', 'supreme-mega-menu' ),
			'fadeInLeft'        => esc_html__( 'Fade In Left', 'supreme-mega-menu' ),
			'fadeInLeftBig'     => esc_html__( 'Fade In Left Big', 'supreme-mega-menu' ),
			'fadeInRight'       => esc_html__( 'Fade In Right', 'supreme-mega-menu' ),
			'fadeInRightBig'    => esc_html__( 'Fade In Right Big', 'supreme-mega-menu' ),
			'fadeInDown'        => esc_html__( 'Fade In Down', 'supreme-mega-menu' ),
			'fadeInDownBig'     => esc_html__( 'Fade In Down Big', 'supreme-mega-menu' ),
			'fadeInUp'          => esc_html__( 'Fade In Up', 'supreme-mega-menu' ),
			'fadeInUpBig'       => esc_html__( 'Fade In Up Big', 'supreme-mega-menu' ),
			'bounce'            => esc_html__( 'Bounce', 'supreme-mega-menu' ),
			'flash'             => esc_html__( 'Flash', 'supreme-mega-menu' ),
			'pulse'             => esc_html__( 'Pulse', 'supreme-mega-menu' ),
			'rubberBand'        => esc_html__( 'Rubber Band', 'supreme-mega-menu' ),
			'shake'             => esc_html__( 'Shake', 'supreme-mega-menu' ),
			'swing'             => esc_html__( 'Swing', 'supreme-mega-menu' ),
			'tada'              => esc_html__( 'Tada', 'supreme-mega-menu' ),
			'wobble'            => esc_html__( 'Wobble', 'supreme-mega-menu' ),
			'jello'             => esc_html__( 'Jello', 'supreme-mega-menu' ),
			'lightSpeedIn'      => esc_html__( 'Light Speed In', 'supreme-mega-menu' ),
			'rollIn'            => esc_html__( 'Roll In', 'supreme-mega-menu' ),
			'hinge'             => esc_html__( 'Hinge', 'supreme-mega-menu' ),
			'bounceIn'          => esc_html__( 'bounceIn', 'supreme-mega-menu' ),
			'bounceInDown'      => esc_html__( 'bounceInDown', 'supreme-mega-menu' ),
			'bounceInLeft'      => esc_html__( 'bounceInLeft', 'supreme-mega-menu' ),
			'bounceInRight'     => esc_html__( 'bounceInRight', 'supreme-mega-menu' ),
			'bounceInUp'        => esc_html__( 'bounceInUp', 'supreme-mega-menu' ),
			'slideInUp'         => esc_html__( 'Slide In Up', 'supreme-mega-menu' ),
			'slideInDown'       => esc_html__( 'Slide In Down', 'supreme-mega-menu' ),
			'slideInLeft'       => esc_html__( 'Slide In Left', 'supreme-mega-menu' ),
			'slideInRight'      => esc_html__( 'Slide In Right', 'supreme-mega-menu' ),
			'flip'              => esc_html__( 'Flip', 'supreme-mega-menu' ),
			'flipInX'           => esc_html__( 'Flip In X', 'supreme-mega-menu' ),
			'flipInY'           => esc_html__( 'Flip In Y', 'supreme-mega-menu' ),
			'rotateIn'          => esc_html__( 'Rotate In', 'supreme-mega-menu' ),
			'rotateInDownLeft'  => esc_html__( 'Rotate In Down Left', 'supreme-mega-menu' ),
			'rotateInDownRight' => esc_html__( 'Rotate In Down Right', 'supreme-mega-menu' ),
			'rotateInUpLeft'    => esc_html__( 'Rotate In Up Left', 'supreme-mega-menu' ),
			'rotateInUpRight'   => esc_html__( 'Rotate In Up Right', 'supreme-mega-menu' ),
			'zoomIn'            => esc_html__( 'Zoom In', 'supreme-mega-menu' ),
			'zoomInDown'        => esc_html__( 'Zoom In Down', 'supreme-mega-menu' ),
			'zoomInLeft'        => esc_html__( 'Zoom In Left', 'supreme-mega-menu' ),
			'zoomInRight'       => esc_html__( 'Zoom In Right', 'supreme-mega-menu' ),
			'zoomInUp'          => esc_html__( 'Zoom In Up', 'supreme-mega-menu' ),
		);

		$dsm_exit_animation_list = array(
			'fadeOut'            => esc_html__( 'Fade Out', 'supreme-mega-menu' ),
			'fadeOutDown'        => esc_html__( 'Fade Out Down', 'supreme-mega-menu' ),
			'fadeOutDownBig'     => esc_html__( 'Fade Out Down Big', 'supreme-mega-menu' ),
			'fadeOutLeft'        => esc_html__( 'Fade Out Left', 'supreme-mega-menu' ),
			'fadeOutLeftBig'     => esc_html__( 'Fade Out Left Big', 'supreme-mega-menu' ),
			'fadeOutRight'       => esc_html__( 'Fade Out Right', 'supreme-mega-menu' ),
			'fadeOutRightBig'    => esc_html__( 'Fade Out Right Big', 'supreme-mega-menu' ),
			'fadeOutDown'        => esc_html__( 'Fade Out Down', 'supreme-mega-menu' ),
			'fadeOutDownBig'     => esc_html__( 'Fade Out Down Big', 'supreme-mega-menu' ),
			'fadeOutUp'          => esc_html__( 'Fade Out Up', 'supreme-mega-menu' ),
			'fadeOutUpBig'       => esc_html__( 'Fade Out Up Big', 'supreme-mega-menu' ),
			'bounceOut'          => esc_html__( 'Bounce Out', 'supreme-mega-menu' ),
			'bounceOutDown'      => esc_html__( 'Bounce Out Down', 'supreme-mega-menu' ),
			'bounceOutLeft'      => esc_html__( 'Bounce Out Left', 'supreme-mega-menu' ),
			'bounceOutRight'     => esc_html__( 'Bounce Out Right', 'supreme-mega-menu' ),
			'bounceOutUp'        => esc_html__( 'Bounce Out Up', 'supreme-mega-menu' ),
			'slideOutUp'         => esc_html__( 'Slide Out Up', 'supreme-mega-menu' ),
			'slideOutDown'       => esc_html__( 'Slide Out Down', 'supreme-mega-menu' ),
			'slideOutLeft'       => esc_html__( 'Slide Out Left', 'supreme-mega-menu' ),
			'slideOutRight'      => esc_html__( 'Slide Out Right', 'supreme-mega-menu' ),
			'flipOutX'           => esc_html__( 'Flip Out X', 'supreme-mega-menu' ),
			'flipOutY'           => esc_html__( 'Flip Out Y', 'supreme-mega-menu' ),
			'rotateOut'          => esc_html__( 'Rotate Out', 'supreme-mega-menu' ),
			'rotateOutDownLeft'  => esc_html__( 'Rotate Out Down Left', 'supreme-mega-menu' ),
			'rotateOutDownRight' => esc_html__( 'Rotate Out Down Right', 'supreme-mega-menu' ),
			'rotateOutUpLeft'    => esc_html__( 'Rotate Out Up Left', 'supreme-mega-menu' ),
			'rotateOutUpRight'   => esc_html__( 'Rotate Out Up Right', 'supreme-mega-menu' ),
			'zoomOut'            => esc_html__( 'Zoom Out', 'supreme-mega-menu' ),
			'zoomOutDown'        => esc_html__( 'Zoom Out Down', 'supreme-mega-menu' ),
			'zoomOutLeft'        => esc_html__( 'Zoom Out Left', 'supreme-mega-menu' ),
			'zoomOutRight'       => esc_html__( 'Zoom Out Right', 'supreme-mega-menu' ),
			'zoomOutUp'          => esc_html__( 'Zoom Out Up', 'supreme-mega-menu' ),
		);

		return array(
			'dsm_layout'                        => array(
				'label'           => esc_html__( 'Layout', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'horizontal',
				'option_category' => 'configuration',
				'options'         => array(
					'horizontal' => esc_html__( 'Horizontal', 'supreme-mega-menu' ),
					'vertical'   => esc_html__( 'Vertical', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'main_content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_dropdown_position'             => array(
				'label'           => esc_html__( 'Position', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'left',
				'option_category' => 'configuration',
				'options'         => array(
					'left'  => esc_html__( 'Left', 'supreme-mega-menu' ),
					'right' => esc_html__( 'Right', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'main_content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),

				'show_if'         => array(
					'dsm_layout' => 'vertical',
				),
			),

			'dsm_trigger'                       => array(
				'label'           => esc_html__( 'Trigger', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'hover',
				'option_category' => 'configuration',
				'options'         => array(
					'click' => esc_html__( 'Click', 'supreme-mega-menu' ),
					'hover' => esc_html__( 'Hover', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'main_content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_dropdown_animation'            => array(
				'label'           => esc_html__( 'Dropdown Animation', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'none',
				'option_category' => 'configuration',
				'options'         => $dsm_animation_list,
				'tab_slug'        => 'general',
				'toggle_slug'     => 'main_content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_link_animation'                => array(
				'label'           => esc_html__( 'Link Animation', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'none',
				'option_category' => 'configuration',
				'options'         => array(
					'none'                            => esc_html__( 'None', 'supreme-mega-menu' ),
					'dsm_link_animation_effect_one'   => esc_html__( 'Effect 1', 'supreme-mega-menu' ),
					'dsm_link_animation_effect_two'   => esc_html__( 'Effect 2', 'supreme-mega-menu' ),
					'dsm_link_animation_effect_three' => esc_html__( 'Effect 3', 'supreme-mega-menu' ),
					'dsm_link_animation_effect_four'  => esc_html__( 'Effect 4', 'supreme-mega-menu' ),
					'dsm_link_animation_effect_five'  => esc_html__( 'Effect 5', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'main_content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_mobile_trigger'                => array(
				'label'           => esc_html__( 'Mobile Trigger', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'icon',
				'option_category' => 'configuration',
				'options'         => array(
					'item' => esc_html__( 'Menu Item', 'supreme-mega-menu' ),
					'icon' => esc_html__( 'Icon', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'main_content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_mobile_entrance_animation'     => array(
				'label'           => esc_html__( 'Mobile Entrance Animation', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'none',
				'option_category' => 'configuration',
				'options'         => $dsm_animation_list,
				'tab_slug'        => 'general',
				'toggle_slug'     => 'main_content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_mobile_exit_animation'     => array(
				'label'           => esc_html__( 'Mobile Exit Animation', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'fadeOut',
				'option_category' => 'configuration',
				'options'         => $dsm_exit_animation_list,
				'tab_slug'        => 'general',
				'toggle_slug'     => 'main_content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_mobile_hamburger_alignment'    => array(
				'label'           => esc_html__( 'Mobile Hamburger Alignment', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'dsm_hamburger_right',
				'option_category' => 'configuration',
				'options'         => array(
					'dsm_hamburger_right' => esc_html__( 'Hamburger right, Logo Left', 'supreme-mega-menu' ),
					'dsm_hamburger_left'  => esc_html__( 'Hamburger Left, Logo right', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'main_content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_logo'                          => array(
				'label'              => esc_html__( 'Logo', 'supreme-mega-menu' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'default'            => '',
				'upload_button_text' => esc_attr__( 'Upload an image', 'supreme-mega-menu' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'supreme-mega-menu' ),
				'update_text'        => esc_attr__( 'Set As Image', 'supreme-mega-menu' ),
				'description'        => esc_html__( '', 'supreme-mega-menu' ),
				'toggle_slug'        => 'dsm_logo_panel',
			),

			'dsm_logo_url'                      => array(
				'label'           => esc_html__( 'Logo Link URL', 'supreme-mega-menu' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_logo_panel',
			),
			'dsm_logo_url_new_window'           => array(
				'label'           => esc_html__( 'Logo Link Target', 'supreme-mega-menu' ),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'In The Same Window', 'supreme-mega-menu' ),
					'on'  => esc_html__( 'In The New Tab', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_logo_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_logo_width'                    => array(
				'label'           => esc_html__( 'Width', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default_unit'    => '%',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_logo_panel',
			),

			'dsm_logo_height'                   => array(
				'label'           => esc_html__( 'Height', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '200',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_logo_panel',
			),

			'dsm_link_animation_color'          => array(
				'label'       => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'        => 'color-alpha',
				'description' => esc_html__( '', 'supreme-mega-menu' ),
				'default'     => '#000000',
				'hover'       => 'tabs',
				'tab_slug'    => 'general',
				'toggle_slug' => 'main_content',

				'show_if_not' => array(
					'dsm_link_animation' => 'none',
				),
			),

			'dsm_menu_gap'                      => array(
				'label'           => esc_html__( 'Gap', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '20px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'main_content',
			),

			'dsm_show_arrow'                    => array(
				'label'           => esc_html__( 'Show Arrow', 'supreme-mega-menu' ),
				'type'            => 'yes_no_button',
				'option_category' => 'basic_option',
				'default'         => 'off',
				'options'         => array(
					'off' => esc_html__( 'No', 'supreme-mega-menu' ),
					'on'  => esc_html__( 'Yes', 'supreme-mega-menu' ),
				),
				'mobile_options'  => true,
				'responsive'      => true,
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_element_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_show_search_icon'              => array(
				'label'           => esc_html__( 'Show Search Icon', 'supreme-mega-menu' ),
				'type'            => 'yes_no_button',
				'option_category' => 'basic_option',
				'default'         => 'off',
				'options'         => array(
					'off' => esc_html__( 'No', 'supreme-mega-menu' ),
					'on'  => esc_html__( 'Yes', 'supreme-mega-menu' ),
				),
				'mobile_options'  => true,
				'responsive'      => true,
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_element_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_search_font_icon'              => array(
				'label'           => esc_html__( 'Search Icon', 'supreme-mega-menu' ),
				'type'            => 'select_icon',
				'option_category' => 'basic_option',
				'default'         => 'U',
				'class'           => array( 'et-pb-font-icon' ),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_element_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),

				'show_if'         => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_field_position'         => array(
				'label'           => esc_html__( 'Search Field Position', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'bottom',
				'option_category' => 'configuration',
				'options'         => array(
					'top'    => esc_html__( 'Top', 'supreme-mega-menu' ),
					'bottom' => esc_html__( 'Bottom', 'supreme-mega-menu' ),
					'left'   => esc_html__( 'Left', 'supreme-mega-menu' ),
					'right'  => esc_html__( 'Right', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_element_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),

				'show_if'         => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_icon_color'             => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '#000000',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_search_icon_panel',

				'show_if'        => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_icon_bg_color'          => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_search_icon_panel',

				'show_if'        => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_icon_font_size'         => array(
				'label'           => esc_html__( 'Font Size', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '18px',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_search_icon_panel',

				'show_if'         => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_icon_margin'            => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_search_icon_panel',
				'mobile_options'  => true,
				'responsive'      => true,

				'show_if'         => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_icon_padding'           => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_search_icon_panel',
				'mobile_options'  => true,
				'responsive'      => true,

				'show_if'         => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_field_text_color'       => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '#000000',
				'mobile_options' => true,
				'responsive'     => true,
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_search_field_panel',

				'show_if'        => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_field_text_bg_color'    => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '#f5f5f5',
				'mobile_options' => true,
				'responsive'     => true,
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_search_field_panel',

				'show_if'        => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_field_margin'           => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_search_field_panel',
				'mobile_options'  => true,
				'responsive'      => true,

				'show_if'         => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_field_padding'          => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '10|10|10|10',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_search_field_panel',
				'mobile_options'  => true,
				'responsive'      => true,

				'show_if'         => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_field_width'            => array(
				'label'           => esc_html__( 'Width', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '300px',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '1000',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_search_field_panel',

				'show_if'         => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_field_mobile_width'     => array(
				'label'           => esc_html__( 'Mobile Width', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '100%',
				'default_unit'    => '%',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_search_field_panel',

				'show_if'         => array(
					'dsm_show_search_icon' => 'on',
				),
			),

			'dsm_search_field_mobile_alignment' => array(
				'label'           => esc_html__( 'Mobile Alignment', 'supreme-mega-menu' ),
				'type'            => 'multiple_buttons',
				'options'         => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'supreme-mega-menu' ),
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'supreme-mega-menu' ),
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'supreme-mega-menu' ),
					),
				),
				'default'         => 'center',
				'toggleable'      => true,
				'multi_selection' => false,
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_search_field_panel',

				'show_if'         => array(
					'dsm_layout' => 'horizontal',
				),
			),

			'dsm_alignment'                     => array(
				'label'           => esc_html__( 'Alignment', 'supreme-mega-menu' ),
				'type'            => 'multiple_buttons',
				'options'         => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'supreme-mega-menu' ),
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'supreme-mega-menu' ),
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'supreme-mega-menu' ),
					),
					'justified'  => array(
						'title' => esc_html__( 'Justified', 'supreme-mega-menu' ),
					),
				),

				'default'         => 'center',
				'toggleable'      => true,
				'multi_selection' => false,
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_alignment_panel',

				'show_if'         => array(
					'dsm_layout' => 'horizontal',
				),
			),

			'dsm_menu_item_color'               => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '#000000',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_menu_panel',
			),

			'dsm_menu_item_bg_color'            => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_menu_panel',
			),

			'dsm_menu_item_margin'              => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_menu_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_menu_item_padding'             => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_menu_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_width'                         => array(
				'label'           => esc_html__( 'Dropdown width', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'container',
				'option_category' => 'configuration',
				'options'         => array(
					'container'    => esc_html__( 'Container', 'supreme-mega-menu' ),
					'fullwidth'    => esc_html__( 'Fullwidth', 'supreme-mega-menu' ),
					'custom_width' => esc_html__( 'Custom Width', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),

				'show_if'         => array(
					'dsm_layout' => 'horizontal',
				),
			),

			'dsm_custom_width'                  => array(
				'label'           => esc_html__( 'Width', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '200px',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '1000',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',

				'show_if'         => array(
					'dsm_width'  => 'custom_width',
					'dsm_layout' => 'horizontal',
				),
			),

			'dsm_badge_position'                => array(
				'label'           => esc_html__( 'Position', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'left',
				'option_category' => 'configuration',
				'options'         => array(
					'relative' => esc_html__( 'Relative', 'supreme-mega-menu' ),
					'absolute' => esc_html__( 'Absolute', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_badge_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_badge_top_pos'                 => array(
				'label'           => esc_html__( 'Top', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '0%',
				'default_unit'    => '%',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_badge_panel',

				'show_if'         => array(
					'dsm_badge_position' => 'absolute',
				),
			),

			'dsm_badge_left_pos'                => array(
				'label'           => esc_html__( 'Left', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '0%',
				'default_unit'    => '%',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_badge_panel',

				'show_if'         => array(
					'dsm_badge_position' => 'absolute',
				),
			),

			'dsm_badge_text_color'              => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_badge_panel',
			),

			'dsm_badge_text_bg_color'           => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'tab_slug'       => 'advanced',
				'hover'          => 'tabs',
				'toggle_slug'    => 'dsm_badge_panel',
			),

			'dsm_badge_margin'                  => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_badge_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_badge_padding'                 => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_badge_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_dropdown_width'                => array(
				'label'           => esc_html__( 'Width', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '700px',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '1200',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',

				'show_if'         => array(
					'dsm_layout' => 'vertical',
				),
			),

			'dsm_dropdown_gap'                  => array(
				'label'           => esc_html__( 'Gap', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '150',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',

				'show_if'         => array(
					'dsm_layout' => 'vertical',
				),
			),

			'dsm_use_custom_height'             => array(
				'label'           => esc_html__( 'Custom Height', 'supreme-mega-menu' ),
				'type'            => 'yes_no_button',
				'option_category' => 'basic_option',
				'default'         => 'off',
				'options'         => array(
					'off' => esc_html__( 'No', 'supreme-mega-menu' ),
					'on'  => esc_html__( 'Yes', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_dropdown_height'               => array(
				'label'           => esc_html__( 'Height', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '500px',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '1000',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',

				'show_if'         => array(
					'dsm_use_custom_height' => 'on',
				),
			),

			'dsm_dropdown_icon_color'           => array(
				'label'          => esc_html__( 'Icon Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '#000000',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_dropdown_panel',
			),

			'dsm_dropdown_icon_font_size'       => array(
				'label'           => esc_html__( 'Icon Font Size', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '16px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
			),

			'dsm_dropdown_bg_color'             => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '#ffffff',
				'mobile_options' => true,
				'responsive'     => true,
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_dropdown_panel',
			),

			'dsm_dropdown_margin'               => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_dropdown_padding'              => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_image_width'                   => array(
				'label'           => esc_html__( 'Width', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '16px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '150',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',
			),

			'dsm_icon_font_size'                => array(
				'label'           => esc_html__( 'Font Size', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '16px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '150',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',
			),

			'dsm_icon_color'                    => array(
				'label'          => esc_html__( 'Icon Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_image_icon_panel',
			),

			'dsm_image_icon_bg_color'           => array(
				'label'          => esc_html__( 'Image Icon Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_image_icon_panel',
			),

			'dsm_image_icon_margin'             => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_image_icon_padding'            => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_submenu_color'                 => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '#000000',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_submenu_panel',
			),

			'dsm_submenu_bg_color'              => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_submenu_panel',
			),

			'dsm_submenu_margin'                => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_submenu_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_submenu_padding'               => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '5px|10px|5px|10px',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_submenu_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_cart_icon_color'               => array(
				'label'          => esc_html__( 'Icon Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_cart_panel',
			),

			'dsm_cart_icon_font_size'           => array(
				'label'           => esc_html__( 'Icon Font Size', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '18px',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_cart_panel',
			),

			'dsm_cart_count_color'              => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_cart_panel',
			),

			'dsm_cart_count_bg_color'           => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_cart_panel',
			),

			'dsm_cart_count_margin'             => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_cart_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_cart_count_padding'            => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_cart_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_vertical_dropdown_placement'   => array(
				'label'           => esc_html__( 'Vertical Dropdown Placement', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'current_item',
				'option_category' => 'configuration',
				'options'         => array(
					'top'          => esc_html__( 'Top', 'supreme-mega-menu' ),
					'current_item' => esc_html__( 'With Current Item', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_menu_container_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_menu_item_container_width'     => array(
				'label'           => esc_html__( 'Width', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '300px',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '1000',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_menu_container_panel',

				'show_if'         => array(
					'dsm_layout' => 'vertical',
				),
			),

			'dsm_menu_container_bg_color'       => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_menu_container_panel',

				'show_if'        => array(
					'dsm_layout' => 'vertical',
				),
			),

			'dsm_menu_container_padding'        => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_menu_container_panel',
				'mobile_options'  => true,
				'responsive'      => true,

				'show_if'         => array(
					'dsm_layout' => 'vertical',
				),
			),

			'dsm_arrow_color'                   => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '#000000',
				'mobile_options' => true,
				'responsive'     => true,
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_arrow_panel',

				'show_if'        => array(
					'dsm_show_arrow' => 'on',
				),
			),

			'dsm_mobile_open_font_icon'         => array(
				'label'           => esc_html__( 'Icon', 'supreme-mega-menu' ),
				'type'            => 'select_icon',
				'option_category' => 'basic_option',
				'default'         => '&#x61;||divi||400',
				'class'           => array( 'et-pb-font-icon' ),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_hamburger_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_open_icon_font_size'           => array(
				'label'           => esc_html__( 'Font Size', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '16px',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_hamburger_panel',
			),

			'dsm_hamburger_icon_color'          => array(
				'label'       => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'        => 'color-alpha',
				'description' => esc_html__( '', 'supreme-mega-menu' ),
				'default'     => '#000000',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'dsm_hamburger_panel',
			),

			'dsm_hamburger_icon_bg_color'       => array(
				'label'       => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'        => 'color-alpha',
				'description' => esc_html__( '', 'supreme-mega-menu' ),
				'default'     => '',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'dsm_hamburger_panel',
			),

			'dsm_hamburger_icon_margin'         => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_hamburger_panel',
			),

			'dsm_hamburger_icon_padding'        => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_hamburger_panel',
			),

			'dsm_mobile_container_alignment'    => array(
				'label'           => esc_html__( 'Alignment', 'supreme-mega-menu' ),
				'type'            => 'multiple_buttons',
				'options'         => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'supreme-mega-menu' ),
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'supreme-mega-menu' ),
					),

					'right'  => array(
						'title' => esc_html__( 'Right', 'supreme-mega-menu' ),
					),
				),
				'default'         => 'left',
				'toggleable'      => true,
				'multi_selection' => false,
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_mobile_container_panel',
			),

			'dsm_mobile_container_width'        => array(
				'label'          => esc_html__( 'Width', 'supreme-mega-menu' ),
				'type'           => 'range',
				'default'        => '100%',
				'default_unit'   => '%',
				'mobile_options' => true,
				'responsive'     => true,
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_mobile_container_panel',
			),

			'dsm_mobile_container_height'       => array(
				'label'          => esc_html__( 'Height', 'supreme-mega-menu' ),
				'type'           => 'range',
				'default'        => '100%',
				'default_unit'   => '%',
				'mobile_options' => true,
				'responsive'     => true,
				'range_settings' => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_mobile_container_panel',
			),

			'dsm_mobile_container_bg_color'     => array(
				'label'       => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'        => 'color-alpha',
				'description' => esc_html__( '', 'supreme-mega-menu' ),
				'default'     => '',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'dsm_mobile_container_panel',
			),

			'dsm_mobile_container_margin'       => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_mobile_container_panel',
			),

			'dsm_mobile_container_padding'      => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_mobile_container_panel',
			),

			'dsm_mobile_close_font_icon'        => array(
				'label'           => esc_html__( 'Icon', 'supreme-mega-menu' ),
				'type'            => 'select_icon',
				'option_category' => 'basic_option',
				'default'         => '&#x4d;||divi||400',
				'class'           => array( 'et-pb-font-icon' ),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_mobile_close_icon_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_close_icon_font_size'          => array(
				'label'           => esc_html__( 'Font Size', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '16px',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_mobile_close_icon_panel',
			),

			'dsm_close_icon_color'              => array(
				'label'       => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'        => 'color-alpha',
				'description' => esc_html__( '', 'supreme-mega-menu' ),
				'default'     => '#000000',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'dsm_mobile_close_icon_panel',
			),

			'dsm_close_icon_bg_color'           => array(
				'label'       => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'        => 'color-alpha',
				'description' => esc_html__( '', 'supreme-mega-menu' ),
				'default'     => '',
				'tab_slug'    => 'advanced',
				'toggle_slug' => 'dsm_mobile_close_icon_panel',
			),

			'dsm_close_icon_margin'             => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_mobile_close_icon_panel',
			),

			'dsm_close_icon_padding'            => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_mobile_close_icon_panel',
			),

			'dsm_close_icon_top_position'       => array(
				'label'           => esc_html__( 'Top', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '2%',
				'default_unit'    => '%',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_mobile_close_icon_panel',
			),

			'dsm_close_icon_left_position'      => array(
				'label'           => esc_html__( 'Left', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '90%',
				'default_unit'    => '%',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_mobile_close_icon_panel',
			),
		);
	}

	function get_search_form() {
		return sprintf(
			'<div class="dsm-mega-menu-search-box">
				<div class="et_pb_menu__search">
					<form role="search" method="get" class="et_pb_menu__search-form" action="%1$s">
						<input type="search" class="et_pb_menu__search-input" placeholder="%2$s" name="s" title="%3$s" />
					</form>
				</div>
			</div>',
			esc_url( home_url( '/' ) ),
			esc_attr__( 'Search &hellip;', 'et_builder' ),
			esc_attr__( 'Search for:', 'et_builder' )
		);
	}

	function before_render() {
		global $dsm_dropdown_position, $dsm_layout, $dsm_show_search_icon, $dsm_dropdown_animation, $dsm_trigger;

		$multi_view = et_pb_multi_view_options( $this );

		$dsm_dropdown_position  = $this->props['dsm_dropdown_position'];
		$dsm_layout             = $this->props['dsm_layout'];
		$dsm_dropdown_animation = $this->props['dsm_dropdown_animation'];
		$dsm_trigger            = $this->props['dsm_trigger'];
	}

	public function render( $attrs, $content, $render_slug ) {
		$multi_view = et_pb_multi_view_options( $this );

		$dsm_menu_gap_last_edited                      = $this->props['dsm_menu_gap_last_edited'];
		$dsm_menu_gap_responsive_active                = et_pb_get_responsive_status( $dsm_menu_gap_last_edited );
		$dsm_menu_item_margin_last_edited              = $this->props['dsm_menu_item_margin_last_edited'];
		$dsm_menu_item_margin_responsive_active        = et_pb_get_responsive_status( $dsm_menu_item_margin_last_edited );
		$dsm_menu_item_padding_last_edited             = $this->props['dsm_menu_item_padding_last_edited'];
		$dsm_menu_item_padding_responsive_active       = et_pb_get_responsive_status( $dsm_menu_item_padding_last_edited );
		$dsm_custom_width_last_edited                  = $this->props['dsm_custom_width_last_edited'];
		$dsm_custom_width_responsive_active            = et_pb_get_responsive_status( $dsm_custom_width_last_edited );
		$dsm_menu_item_color_last_edited               = $this->props['dsm_menu_item_color_last_edited'];
		$dsm_menu_item_color_responsive_active         = et_pb_get_responsive_status( $dsm_menu_item_color_last_edited );
		$dsm_menu_item_bg_color_last_edited            = $this->props['dsm_menu_item_bg_color_last_edited'];
		$dsm_menu_item_bg_color_responsive_active      = et_pb_get_responsive_status( $dsm_menu_item_bg_color_last_edited );
		$dsm_badge_text_color_last_edited              = $this->props['dsm_badge_text_color_last_edited'];
		$dsm_badge_text_color_responsive_active        = et_pb_get_responsive_status( $dsm_badge_text_color_last_edited );
		$dsm_badge_text_bg_color_last_edited           = $this->props['dsm_badge_text_bg_color_last_edited'];
		$dsm_badge_text_bg_color_responsive_active     = et_pb_get_responsive_status( $dsm_badge_text_bg_color_last_edited );
		$dsm_badge_margin_last_edited                  = $this->props['dsm_badge_margin_last_edited'];
		$dsm_badge_margin_responsive_active            = et_pb_get_responsive_status( $dsm_badge_margin_last_edited );
		$dsm_badge_padding_last_edited                 = $this->props['dsm_badge_padding_last_edited'];
		$dsm_badge_padding_responsive_active           = et_pb_get_responsive_status( $dsm_badge_padding_last_edited );
		$dsm_dropdown_bg_color_last_edited             = $this->props['dsm_dropdown_bg_color_last_edited'];
		$dsm_dropdown_bg_color_responsive_active       = et_pb_get_responsive_status( $dsm_dropdown_bg_color_last_edited );
		$dsm_dropdown_margin_last_edited               = $this->props['dsm_dropdown_margin_last_edited'];
		$dsm_dropdown_margin_responsive_active         = et_pb_get_responsive_status( $dsm_dropdown_margin_last_edited );
		$dsm_dropdown_padding_last_edited              = $this->props['dsm_dropdown_padding_last_edited'];
		$dsm_dropdown_padding_responsive_active        = et_pb_get_responsive_status( $dsm_dropdown_padding_last_edited );
		$dsm_dropdown_height_last_edited               = $this->props['dsm_dropdown_height_last_edited'];
		$dsm_dropdown_height_responsive_active         = et_pb_get_responsive_status( $dsm_dropdown_height_last_edited );
		$dsm_image_width_last_edited                   = $this->props['dsm_image_width_last_edited'];
		$dsm_image_width_responsive_active             = et_pb_get_responsive_status( $dsm_image_width_last_edited );
		$dsm_icon_font_size_last_edited                = $this->props['dsm_icon_font_size_last_edited'];
		$dsm_icon_font_size_responsive_active          = et_pb_get_responsive_status( $dsm_icon_font_size_last_edited );
		$dsm_icon_color_last_edited                    = $this->props['dsm_icon_color_last_edited'];
		$dsm_icon_color_responsive_active              = et_pb_get_responsive_status( $dsm_icon_color_last_edited );
		$dsm_image_icon_bg_color_last_edited           = $this->props['dsm_image_icon_bg_color_last_edited'];
		$dsm_image_icon_bg_color_responsive_active     = et_pb_get_responsive_status( $dsm_image_icon_bg_color_last_edited );
		$dsm_image_icon_margin_last_edited             = $this->props['dsm_image_icon_margin_last_edited'];
		$dsm_image_icon_margin_responsive_active       = et_pb_get_responsive_status( $dsm_image_icon_margin_last_edited );
		$dsm_image_icon_padding_last_edited            = $this->props['dsm_image_icon_padding_last_edited'];
		$dsm_image_icon_padding_responsive_active      = et_pb_get_responsive_status( $dsm_image_icon_padding_last_edited );
		$dsm_dropdown_icon_color_last_edited           = $this->props['dsm_dropdown_icon_color_last_edited'];
		$dsm_dropdown_icon_color_responsive_active     = et_pb_get_responsive_status( $dsm_dropdown_icon_color_last_edited );
		$dsm_dropdown_icon_font_size_last_edited       = $this->props['dsm_dropdown_icon_font_size_last_edited'];
		$dsm_dropdown_icon_font_size_responsive_active = et_pb_get_responsive_status( $dsm_dropdown_icon_font_size_last_edited );
		$dsm_dropdown_width_last_edited                = $this->props['dsm_dropdown_width_last_edited'];
		$dsm_dropdown_width_responsive_active          = et_pb_get_responsive_status( $dsm_dropdown_width_last_edited );
		$dsm_dropdown_gap_last_edited                  = $this->props['dsm_dropdown_gap_last_edited'];
		$dsm_dropdown_gap_responsive_active            = et_pb_get_responsive_status( $dsm_dropdown_gap_last_edited );
		$dsm_submenu_color_last_edited                 = $this->props['dsm_submenu_color_last_edited'];
		$dsm_submenu_color_responsive_active           = et_pb_get_responsive_status( $dsm_submenu_color_last_edited );
		$dsm_submenu_bg_color_last_edited              = $this->props['dsm_submenu_bg_color_last_edited'];
		$dsm_submenu_bg_color_responsive_active        = et_pb_get_responsive_status( $dsm_submenu_bg_color_last_edited );
		$dsm_submenu_margin_last_edited                = $this->props['dsm_submenu_margin_last_edited'];
		$dsm_submenu_margin_responsive_active          = et_pb_get_responsive_status( $dsm_submenu_margin_last_edited );
		$dsm_submenu_padding_last_edited               = $this->props['dsm_submenu_padding_last_edited'];
		$dsm_submenu_padding_responsive_active         = et_pb_get_responsive_status( $dsm_submenu_padding_last_edited );
		$dsm_cart_count_bg_color_last_edited           = $this->props['dsm_cart_count_bg_color_last_edited'];
		$dsm_cart_count_bg_color_responsive_active     = et_pb_get_responsive_status( $dsm_cart_count_bg_color_last_edited );
		$dsm_cart_count_color_last_edited              = $this->props['dsm_cart_count_color_last_edited'];
		$dsm_cart_count_color_responsive_active        = et_pb_get_responsive_status( $dsm_cart_count_color_last_edited );

		$dsm_cart_count_margin_last_edited        = $this->props['dsm_cart_count_margin_last_edited'];
		$dsm_cart_count_margin_responsive_active  = et_pb_get_responsive_status( $dsm_cart_count_margin_last_edited );
		$dsm_cart_count_padding_last_edited       = $this->props['dsm_cart_count_padding_last_edited'];
		$dsm_cart_count_padding_responsive_active = et_pb_get_responsive_status( $dsm_cart_count_padding_last_edited );

		$dsm_badge_top_pos_last_edited       = $this->props['dsm_badge_top_pos_last_edited'];
		$dsm_badge_top_pos_responsive_active = et_pb_get_responsive_status( $dsm_badge_top_pos_last_edited );

		$dsm_badge_left_pos_last_edited       = $this->props['dsm_badge_left_pos_last_edited'];
		$dsm_badge_left_pos_responsive_active = et_pb_get_responsive_status( $dsm_badge_left_pos_last_edited );

		$dsm_cart_icon_color_last_edited           = $this->props['dsm_cart_icon_color_last_edited'];
		$dsm_cart_icon_color_responsive_active     = et_pb_get_responsive_status( $dsm_cart_icon_color_last_edited );
		$dsm_cart_icon_font_size_last_edited       = $this->props['dsm_cart_icon_font_size_last_edited'];
		$dsm_cart_icon_font_size_responsive_active = et_pb_get_responsive_status( $dsm_cart_icon_font_size_last_edited );

		$dsm_search_icon_color_last_edited       = $this->props['dsm_search_icon_color_last_edited'];
		$dsm_search_icon_color_responsive_active = et_pb_get_responsive_status( $dsm_search_icon_color_last_edited );

		$dsm_search_icon_font_size_last_edited       = $this->props['dsm_search_icon_font_size_last_edited'];
		$dsm_search_icon_font_size_responsive_active = et_pb_get_responsive_status( $dsm_search_icon_font_size_last_edited );

		$dsm_search_icon_bg_color_last_edited       = $this->props['dsm_search_icon_bg_color_last_edited'];
		$dsm_search_icon_bg_color_responsive_active = et_pb_get_responsive_status( $dsm_search_icon_bg_color_last_edited );

		$dsm_search_icon_padding_last_edited       = $this->props['dsm_search_icon_padding_last_edited'];
		$dsm_search_icon_padding_responsive_active = et_pb_get_responsive_status( $dsm_search_icon_padding_last_edited );

		$dsm_search_icon_margin_last_edited       = $this->props['dsm_search_icon_margin_last_edited'];
		$dsm_search_icon_margin_responsive_active = et_pb_get_responsive_status( $dsm_search_icon_margin_last_edited );

		$dsm_search_field_text_color_last_edited       = $this->props['dsm_search_field_text_color_last_edited'];
		$dsm_search_field_text_color_responsive_active = et_pb_get_responsive_status( $dsm_search_field_text_color_last_edited );

		$dsm_search_field_text_bg_color_last_edited       = $this->props['dsm_search_field_text_bg_color_last_edited'];
		$dsm_search_field_text_bg_color_responsive_active = et_pb_get_responsive_status( $dsm_search_field_text_bg_color_last_edited );

		$dsm_search_field_margin_last_edited       = $this->props['dsm_search_field_margin_last_edited'];
		$dsm_search_field_margin_responsive_active = et_pb_get_responsive_status( $dsm_search_field_margin_last_edited );

		$dsm_search_field_padding_last_edited       = $this->props['dsm_search_field_padding_last_edited'];
		$dsm_search_field_padding_responsive_active = et_pb_get_responsive_status( $dsm_search_field_padding_last_edited );

		$dsm_search_field_width_last_edited       = $this->props['dsm_search_field_width_last_edited'];
		$dsm_search_field_width_responsive_active = et_pb_get_responsive_status( $dsm_search_field_width_last_edited );

		$dsm_menu_container_bg_color_last_edited       = $this->props['dsm_menu_container_bg_color_last_edited'];
		$dsm_menu_container_bg_color_responsive_active = et_pb_get_responsive_status( $dsm_menu_container_bg_color_last_edited );

		$dsm_menu_container_padding_last_edited       = $this->props['dsm_menu_container_padding_last_edited'];
		$dsm_menu_container_padding_responsive_active = et_pb_get_responsive_status( $dsm_menu_container_padding_last_edited );

		$dsm_menu_item_container_width_last_edited       = $this->props['dsm_menu_item_container_width_last_edited'];
		$dsm_menu_item_container_width_responsive_active = et_pb_get_responsive_status( $dsm_menu_item_container_width_last_edited );

		$dsm_arrow_color_last_edited       = $this->props['dsm_arrow_color_last_edited'];
		$dsm_arrow_color_responsive_active = et_pb_get_responsive_status( $dsm_arrow_color_last_edited );

		$dsm_arrow_color_last_edited       = $this->props['dsm_arrow_color_last_edited'];
		$dsm_arrow_color_responsive_active = et_pb_get_responsive_status( $dsm_arrow_color_last_edited );

		$dsm_logo_width_last_edited       = $this->props['dsm_logo_width_last_edited'];
		$dsm_logo_width_responsive_active = et_pb_get_responsive_status( $dsm_logo_width_last_edited );

		$dsm_logo_height_last_edited       = $this->props['dsm_logo_height_last_edited'];
		$dsm_logo_height_responsive_active = et_pb_get_responsive_status( $dsm_logo_height_last_edited );

		$dsm_menu_item_color_hover         = $this->get_hover_value( 'dsm_menu_item_color' );
		$dsm_menu_item_bg_color_hover      = $this->get_hover_value( 'dsm_menu_item_bg_color' );
		$dsm_badge_text_color_hover        = $this->get_hover_value( 'dsm_badge_text_color' );
		$dsm_badge_text_bg_color_hover     = $this->get_hover_value( 'dsm_badge_text_bg_color' );
		$dsm_icon_color_hover              = $this->get_hover_value( 'dsm_icon_color' );
		$dsm_image_icon_bg_color_hover     = $this->get_hover_value( 'dsm_image_icon_bg_color' );
		$dsm_dropdown_icon_color_hover     = $this->get_hover_value( 'dsm_dropdown_icon_color' );
		$dsm_cart_count_bg_color_hover     = $this->get_hover_value( 'dsm_cart_count_bg_color' );
		$dsm_cart_count_color_hover        = $this->get_hover_value( 'dsm_cart_count_color' );
		$dsm_submenu_bg_color_hover        = $this->get_hover_value( 'dsm_submenu_bg_color' );
		$dsm_submenu_color_hover           = $this->get_hover_value( 'dsm_submenu_color' );
		$dsm_search_icon_color_hover       = $this->get_hover_value( 'dsm_search_icon_color' );
		$dsm_search_icon_bg_color_hover    = $this->get_hover_value( 'dsm_search_icon_bg_color' );
		$dsm_menu_container_bg_color_hover = $this->get_hover_value( 'dsm_menu_container_bg_color' );

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
				'declaration' => 'overflow: visible !important;',
			)
		);

		if ( $dsm_menu_item_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link:hover .dsm-menu-text',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_menu_item_color_hover ),
				)
			);
		}

		if ( $dsm_menu_item_bg_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link:hover',
					'declaration' => sprintf( 'background: %1$s !important;', $dsm_menu_item_bg_color_hover ),
				)
			);
		}

		if ( $dsm_badge_text_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link:hover .dsm-badge-text',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_badge_text_color_hover ),
				)
			);
		}

		if ( $dsm_badge_text_bg_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link:hover .dsm-badge-text',
					'declaration' => sprintf( 'background: %1$s !important;', $dsm_badge_text_bg_color_hover ),
				)
			);
		}

		if ( $dsm_icon_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link:hover .dsm_icon',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_icon_color_hover ),
				)
			);
		}

		if ( $dsm_image_icon_bg_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link:hover .dsm_icon',
					'declaration' => sprintf( 'background: %1$s !important;', $dsm_image_icon_bg_color_hover ),
				)
			);
		}

		if ( $dsm_dropdown_icon_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container li a:hover .dsm_dropdown_close_icon, %%order_class%% .dsm-mega-menu-container li a:hover .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_dropdown_icon_color_hover ),
				)
			);
		}

		if ( $dsm_cart_count_bg_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-link:hover .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'background: %1$s !important;', $dsm_cart_count_bg_color_hover ),
				)
			);
		}

		if ( $dsm_cart_count_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-link:hover .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_cart_count_color_hover ),
				)
			);
		}

		if ( $dsm_submenu_bg_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li:hover',
					'declaration' => sprintf( 'background : %1$s !important;', $dsm_submenu_bg_color_hover ),
				)
			);
		}

		if ( $dsm_submenu_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li:hover > a',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_submenu_color_hover ),
				)
			);
		}

		if ( $dsm_search_icon_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button:hover',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_search_icon_color_hover ),
				)
			);
		}

		if ( $dsm_search_icon_bg_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button:hover',
					'declaration' => sprintf( 'background: %1$s !important;', $dsm_search_icon_bg_color_hover ),
				)
			);
		}

		if ( $dsm_menu_container_bg_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.dsm-mega-menu-vertical-layout .dsm-root-menu:hover',
					'declaration' => sprintf( 'background: %1$s !important;', $dsm_menu_container_bg_color_hover ),
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_logo_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-logo-wrap img, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-wrap img',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_dropdown_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-submenu-container .dsm-submenu-inner-container',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_menu_item_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_badge_item_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link .dsm-badge-text',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_submenu_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu ul li',
					'declaration' => 'border-style: solid;overflow:visible;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_cart_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-link .dsm-mega-menu-woo-cart-count',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_image_icon_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_search_icon_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_search_field_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_menu_item_container_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.dsm-mega-menu-vertical-layout .dsm-root-menu',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_hamburger_icon_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mobile-menu-open-button-container .dsm-mega-menu-open-button',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_mobile_container_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( '' === $this->props['border_style_all_dsm_mobile_close_icon_border'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-close-button',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		wp_enqueue_script( 'supreme-mega-menu-frontend-bundle' );

		if ( '' !== $this->props['dsm_logo'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.dsm-mega-menu-vertical-layout)',
					'declaration' => 'align-items: center;',
				)
			);

		}

		$alignment_value = '';
		switch ( $this->props['dsm_alignment'] ) {
			case 'left':
				$alignment_value = 'flex-start';
				break;
			case 'center':
				$alignment_value = 'center';
				break;
			case 'right':
				$alignment_value = 'right';
				break;
			case 'justified':
				$alignment_value = 'space-between';
				break;
		}

		if ( $this->props['dsm_alignment'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.dsm-mega-menu-vertical-layout)',
					'declaration' => sprintf( 'justify-content: %1$s !important;', $alignment_value ),
				)
			);
		}

		if ( 'horizontal' === $this->props['dsm_layout'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu',
					'declaration' => 'padding: 0px !important;',
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu .dsm-mega-menu-item',
					'declaration' => 'display: inline-block;',
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-item.dsm-native-menu, %%order_class%% .dsm-mega-menu-container .dsm-mega-menu-item.dsm-native-menu li',
					'declaration' => 'position:relative;',
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container',
					'declaration' => 'left: 100%;top: 0;',
				)
			);
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-item.dsm-native-menu > .dsm-submenu-container',
					'declaration' => 'left: auto; top: auto;',
				)
			);

			if ( $this->props['dsm_menu_gap'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item',
						'declaration' => sprintf( 'margin-right: %1$s; ', $this->props['dsm_menu_gap'] ),
					)
				);
			}

			if ( $dsm_menu_gap_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item',
						'declaration' => sprintf( 'margin-right: %1$s; ', $this->props['dsm_menu_gap_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_menu_gap_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item',
						'declaration' => sprintf( 'margin-right: %1$s; ', $this->props['dsm_menu_gap_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}

			if ( 'container' === $this->props['dsm_width'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container',
						'declaration' => 'width:200px',
					)
				);
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container',
						'declaration' => 'width: 100%;left:0px;',
					)
				);
			}

			if ( 'fullwidth' === $this->props['dsm_width'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container',
						'declaration' => 'width:200px',
					)
				);
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu .dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container',
						'declaration' => 'position: fixed; width: 100%;left:0px;top:auto;',
					)
				);
			}

			if ( 'custom_width' === $this->props['dsm_width'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item > .dsm-submenu-container',
						'declaration' => 'left:0px;top: auto;',
					)
				);

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item',
						'declaration' => 'position: relative;',
					)
				);

				if ( $this->props['dsm_custom_width'] ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container',
							'declaration' => sprintf( 'width : %1$s; ', $this->props['dsm_custom_width'] ),
						)
					);
				}

				if ( $dsm_custom_width_responsive_active ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container',
							'declaration' => sprintf( 'width : %1$s; ', $this->props['dsm_custom_width_tablet'] ),
							'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
						)
					);
				}

				if ( $dsm_custom_width_responsive_active ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container',
							'declaration' => sprintf( 'width : %1$s; ', $this->props['dsm_custom_width_phone'] ),
							'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						)
					);
				}
			}
		}

		if ( 'vertical' === $this->props['dsm_layout'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container, %%order_class%% .dsm-mega-menu-container nav',
					'declaration' => 'flex-direction: column;',
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
					'declaration' => 'padding: 0px !important;',
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item:last-child',
					'declaration' => 'margin-bottom: 0px !important;',
				)
			);

			$padding   = 'padding';
			$important = true;

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_container_padding'], $padding, $important ),
				)
			);

			if ( $dsm_menu_container_padding_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
						'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_container_padding_tablet'], $padding, $important ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_menu_container_padding_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
						'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_container_padding_phone'], $padding, $important ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}

			if ( $this->props['dsm_menu_container_bg_color'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
						'declaration' => sprintf( 'background : %1$s; ', $this->props['dsm_menu_container_bg_color'] ),
					)
				);
			}

			if ( $dsm_menu_container_bg_color_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
						'declaration' => sprintf( 'background : %1$s; ', $this->props['dsm_menu_container_bg_color_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_menu_container_bg_color_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
						'declaration' => sprintf( 'background : %1$s; ', $this->props['dsm_menu_container_bg_color_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}

			if ( 'top' === $this->props['dsm_vertical_dropdown_placement'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
						'declaration' => 'position: relative !important;',
					)
				);
			}

			if ( 'current_item' === $this->props['dsm_vertical_dropdown_placement'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu li',
						'declaration' => 'position: relative !important;',
					)
				);
			}

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item:last-child',
					'declaration' => 'margin-bottom: 0px !important;',
				)
			);

			if ( $this->props['dsm_menu_gap'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item',
						'declaration' => sprintf( 'margin-bottom: %1$s; ', $this->props['dsm_menu_gap'] ),
					)
				);
			}

			if ( $dsm_menu_gap_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item',
						'declaration' => sprintf( 'margin-bottom: %1$s; ', $this->props['dsm_menu_gap_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_menu_gap_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item',
						'declaration' => sprintf( 'margin-bottom: %1$s; ', $this->props['dsm_menu_gap_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}

			if ( $this->props['dsm_menu_item_container_width'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
						'declaration' => sprintf( 'width : %1$s; ', $this->props['dsm_menu_item_container_width'] ),
					)
				);
			}

			if ( $dsm_menu_item_container_width_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
						'declaration' => sprintf( 'width : %1$s; ', $this->props['dsm_menu_item_container_width_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_menu_item_container_width_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
						'declaration' => sprintf( 'width : %1$s; ', $this->props['dsm_menu_item_container_width_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}

			if ( 'right' === $this->props['dsm_dropdown_position'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
						'declaration' => 'margin: 0 0 0 auto;',
					)
				);

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-logo-wrap',
						'declaration' => 'margin: 0 0 0 auto;',
					)
				);

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-submenu-container',
						'declaration' =>
						'position: absolute;
						                          right: 100%;
										          left: auto;
                                                  top: 0;
    									          z-index: 100;
                                                  -webkit-transform: translateY(0px);
                                                  transform: translateY(0px);',
					)
				);
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-item > .dsm-submenu-container',
						'declaration' => sprintf(
							'position: absolute;right: calc(%1$s + 20px);',
							$this->props['dsm_menu_item_container_width']
						),
					)
				);

				if ( $this->props['dsm_dropdown_gap'] ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-submenu-container',
							'declaration' => sprintf( 'margin-right : %1$s;', $this->props['dsm_dropdown_gap'] ),
						)
					);
				}

				if ( $dsm_dropdown_gap_responsive_active ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-submenu-container',
							'declaration' => sprintf( 'margin-right : %1$s;', $this->props['dsm_dropdown_gap_tablet'] ),
							'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
						)
					);
				}

				if ( $dsm_dropdown_gap_responsive_active ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-submenu-container',
							'declaration' => sprintf( 'margin-right : %1$s;', $this->props['dsm_dropdown_gap_phone'] ),
							'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						)
					);
				}
			}

			if ( 'left' === $this->props['dsm_dropdown_position'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-submenu-container',
						'declaration' => 'position: absolute;
								        top: 0;
								        left: 100%;
								        z-index: 100;
								        webkit-transform: translateY(0px);
								        transform: translateY(0px);',
					)
				);
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-item > .dsm-submenu-container',
						'declaration' => sprintf( 'left : calc(%1$s + 20px);', $this->props['dsm_menu_item_container_width'] ),
					)
				);

				if ( $this->props['dsm_dropdown_gap'] ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-submenu-container',
							'declaration' => sprintf( 'margin-left : %1$s;', $this->props['dsm_dropdown_gap'] ),
						)
					);
				}

				if ( $dsm_dropdown_gap_responsive_active ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-submenu-container',
							'declaration' => sprintf( 'margin-left : %1$s;', $this->props['dsm_dropdown_gap_tablet'] ),
							'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
						)
					);
				}

				if ( $dsm_dropdown_gap_responsive_active ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-submenu-container',
							'declaration' => sprintf( 'margin-left : %1$s;', $this->props['dsm_dropdown_gap_phone'] ),
							'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						)
					);
				}
			}

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu',
					'declaration' => 'display:flex; flex-direction:column;padding: 0;',
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => 'display: flex;
    								  flex-direction: row;
                                      justify-content: space-between;',
				)
			);

			if ( $this->props['dsm_dropdown_width'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-submenu-container',
						'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_dropdown_width'] ),
					)
				);
			}

			if ( $dsm_dropdown_width_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-submenu-container',
						'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_dropdown_width_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_dropdown_width_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-submenu-container',
						'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_dropdown_width_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}
		}

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_padding'], $padding, $important ),
			)
		);

		if ( $dsm_menu_item_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_menu_item_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%%  .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%%  .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_margin'], $margin, $important ),
			)
		);

		if ( $dsm_menu_item_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_menu_item_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_menu_item_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-menu-text',
					'declaration' => sprintf( 'color : %1$s !important;', $this->props['dsm_menu_item_color'] ),
				)
			);
		}

		if ( $dsm_menu_item_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-menu-text',
					'declaration' => sprintf( 'color : %1$s !important;', $this->props['dsm_menu_item_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_menu_item_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => ' %%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-menu-text',
					'declaration' => sprintf( 'color : %1$s !important;', $this->props['dsm_menu_item_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_menu_item_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_menu_item_bg_color'] ),
				)
			);
		}

		if ( $dsm_menu_item_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_menu_item_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_menu_item_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => ' %%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_menu_item_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_badge_text_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_badge_text_color'] ),
				)
			);
		}

		if ( $dsm_badge_text_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_badge_text_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_badge_text_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_badge_text_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_badge_text_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_badge_text_bg_color'] ),
				)
			);
		}

		if ( $dsm_menu_item_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_badge_text_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_menu_item_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_badge_text_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-badge-text',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_margin'], $margin, $important ),
			)
		);

		if ( $dsm_badge_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-badge-text',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_badge_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-badge-text',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-badge-text',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_padding'], $padding, $important ),
			)
		);

		if ( $dsm_badge_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-badge-text',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_badge_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-badge-text',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( 'absolute' === $this->props['dsm_badge_position'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => 'position: relative;',
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => 'position: absolute;',
				)
			);

			if ( $this->props['dsm_badge_top_pos'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'top : %1$s;', $this->props['dsm_badge_top_pos'] ),
					)
				);
			}

			if ( $dsm_badge_top_pos_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'top : %1$s;', $this->props['dsm_badge_top_pos_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_badge_top_pos_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'top : %1$s;', $this->props['dsm_badge_top_pos_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}

			if ( $this->props['dsm_badge_left_pos'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'left : %1$s;', $this->props['dsm_badge_left_pos'] ),
					)
				);
			}

			if ( $dsm_badge_left_pos_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'left : %1$s;', $this->props['dsm_badge_left_pos_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_badge_left_pos_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'left : %1$s;', $this->props['dsm_badge_left_pos_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}
		}

		if ( $this->props['dsm_dropdown_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container .dsm-submenu-inner-container',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_dropdown_bg_color'] ),
				)
			);
		}

		if ( $dsm_dropdown_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container .dsm-submenu-inner-container',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_dropdown_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_dropdown_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container .dsm-submenu-inner-container',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_dropdown_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_dropdown_icon_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm_dropdown_close_icon, %%order_class%% .dsm-mega-menu-container .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_dropdown_icon_color'] ),
				)
			);
		}

		if ( $dsm_dropdown_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm_dropdown_close_icon, %%order_class%% .dsm-mega-menu-container .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_dropdown_icon_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_dropdown_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm_dropdown_close_icon, %%order_class%% .dsm-mega-menu-container .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_dropdown_icon_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_dropdown_icon_font_size'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm_dropdown_close_icon, %%order_class%% .dsm-mega-menu-container .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_dropdown_icon_font_size'] ),
				)
			);
		}

		if ( $dsm_dropdown_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm_dropdown_close_icon, %%order_class%% .dsm-mega-menu-container .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_dropdown_icon_font_size_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_dropdown_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm_dropdown_close_icon, %%order_class%% .dsm-mega-menu-container .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_dropdown_icon_font_size_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item > .dsm-submenu-container',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_dropdown_margin'], $margin, $important ),
			)
		);

		if ( $dsm_dropdown_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item > .dsm-submenu-container',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_dropdown_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_dropdown_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item > .dsm-submenu-container',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_dropdown_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-submenu-container .dsm-submenu-inner-container',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_dropdown_padding'], $padding, $important ),
			)
		);

		if ( $dsm_dropdown_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-submenu-container .dsm-submenu-inner-container',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_dropdown_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_dropdown_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-submenu-container .dsm-submenu-inner-container',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_dropdown_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( 'on' === $this->props['dsm_use_custom_height'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container .dsm-submenu-inner-container',
					'declaration' => 'overflow-y:scroll !important;',
				)
			);

			if ( $this->props['dsm_dropdown_height'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container .dsm-submenu-inner-container',
						'declaration' => sprintf( 'height : %1$s;', $this->props['dsm_dropdown_height'] ),
					)
				);
			}

			if ( $dsm_dropdown_height_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container .dsm-submenu-inner-container',
						'declaration' => sprintf( 'height : %1$s;', $this->props['dsm_dropdown_height_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_dropdown_height_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container .dsm-submenu-inner-container',
						'declaration' => sprintf( 'height : %1$s;', $this->props['dsm_dropdown_height_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}
		}

		if ( $this->props['dsm_icon_font_size'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_icon_font_size'] ),
				)
			);
		}

		if ( $dsm_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_icon_font_size_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_icon_font_size_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_image_width'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image',
					'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_image_width'] ),
				)
			);
		}

		if ( $dsm_image_width_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image',
					'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_image_width_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_image_width_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image',
					'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_image_width_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_icon_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link .dsm_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_icon_color'] ),
				)
			);
		}

		if ( $dsm_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link .dsm_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_icon_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-link .dsm_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_icon_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_image_icon_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_image_icon_bg_color'] ),
				)
			);
		}

		if ( $dsm_image_icon_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_image_icon_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_image_icon_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_image_icon_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_margin'], $margin, $important ),
			)
		);

		if ( $dsm_image_icon_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_image_icon_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_padding'], $padding, $important ),
			)
		);

		if ( $dsm_image_icon_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_image_icon_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm-image, %%order_class%% .dsm-mega-menu-container .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		// submenu styling work

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_margin'], $margin, $important ),
			)
		);

		if ( $dsm_submenu_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_submenu_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_padding'], $padding, $important ),
			)
		);

		if ( $dsm_submenu_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_submenu_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_submenu_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container a',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_submenu_color'] ),
				)
			);
		}

		if ( $dsm_submenu_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container a',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_submenu_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_submenu_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container a',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_submenu_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_submenu_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_submenu_bg_color'] ),
				)
			);
		}

		if ( $dsm_submenu_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_submenu_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_submenu_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_submenu_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( 'horizontal' === $this->props['dsm_layout'] ) {

			if ( 'on' === $this->props['dsm_show_arrow'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item > .dsm-submenu-container::before',
						'declaration' => 'content: "";
                                          position: absolute;
                                          clip-path: polygon(50% 0%, 0% 100%, 100% 100%);
                                          top: -14px;
                                          left: var(--dsm-arrow-center-position);
                                          transform: translateX(-50%);
                                          width: 20px;
                                          height: 15px;
                                          background: inherit;',
					)
				);
			}

			if ( 'on' === $this->props['dsm_show_arrow_tablet'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item > .dsm-submenu-container::before',
						'declaration' => 'content: "";
										position: absolute;
										clip-path: polygon(50% 0%, 0% 100%, 100% 100%);
										top: -14px;
										left: var(--dsm-arrow-center-position);
										transform: translateX(-50%);
										width: 20px;
										height: 15px;
										background: inherit;',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( 'on' === $this->props['dsm_show_arrow_phone'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item > .dsm-submenu-container::before',
						'declaration' => 'content: "";
										position: absolute;
										clip-path: polygon(50% 0%, 0% 100%, 100% 100%);
										top: -14px;
										left: var(--dsm-arrow-center-position);
										transform: translateX(-50%);
										width: 20px;
										height: 15px;
										background: inherit;',
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}
		}

		if ( 'vertical' === $this->props['dsm_layout'] ) {

			if ( 'on' === $this->props['dsm_show_arrow'] ) {

				if ( 'left' === $this->props['dsm_dropdown_position'] ) {

					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-submenu-container::before',
							'declaration' => 'content: "";
                                                   position: absolute;
                                                   clip-path: polygon(0 47%,100% 100%,100% 0);
                                                   top: 10px;
                                                   left: -17px;
                                                   width: 27px;
                                                   height: 27px;
												   z-index:-1;',
						)
					);
				}

				if ( 'right' === $this->props['dsm_dropdown_position'] ) {

					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '%%order_class%% .dsm-mega-menu-item .dsm-submenu-container::before',
							'declaration' => 'content: "";
                                                   position: absolute;
                                                   clip-path: polygon(100% 52%, 0 0, 1% 100%);
                                                   top: 10px;
                                                   right: -17px;
                                                   width: 27px;
                                                   height: 27px;
												   z-index:-1;',
						)
					);
				}
			}
		}

		if ( 'off' === $this->props['dsm_show_arrow'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container::before',
					'declaration' => 'content: "";
										clip-path: none !important;
										width: 0px !important;
										height: 0px !important;
										',
				)
			);
		}

		if ( 'off' === $this->props['dsm_show_arrow_tablet'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container::before',
					'declaration' => 'content: "";
										clip-path: none !important;
										width: 0px !important;
										height: 0px !important;',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( 'off' === $this->props['dsm_show_arrow_phone'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container::before',
					'declaration' => 'content: "";
										clip-path: none !important;
										width: 0px !important;
										height: 0px !important;',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_margin'], $margin, $important ),
			)
		);

		if ( $dsm_cart_count_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_count_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_padding'], $padding, $important ),
			)
		);

		if ( $dsm_cart_count_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_count_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_cart_count_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_cart_count_bg_color'] ),
				)
			);
		}

		if ( $dsm_cart_count_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_cart_count_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_count_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_cart_count_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_cart_count_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_cart_count_color'] ),
				)
			);
		}

		if ( $dsm_cart_count_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_cart_count_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_count_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_cart_count_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_cart_icon_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_cart_icon_color'] ),
				)
			);
		}

		if ( $dsm_cart_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_cart_icon_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_cart_icon_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_cart_icon_font_size'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_cart_icon_font_size'] ),
				)
			);
		}

		if ( $dsm_cart_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_cart_icon_font_size_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_cart_icon_font_size_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		// search icon styling

		if ( $this->props['dsm_search_icon_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_search_icon_color'] ),
				)
			);
		}

		if ( $dsm_search_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_search_icon_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_search_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_search_icon_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_search_icon_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_search_icon_bg_color'] ),
				)
			);
		}

		if ( $dsm_search_icon_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_search_icon_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_search_icon_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_search_icon_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_search_icon_font_size'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_search_icon_font_size'] ),
				)
			);
		}

		if ( $dsm_search_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_search_icon_font_size_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_search_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_search_icon_font_size_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_icon_margin'], $margin, $important ),
			)
		);

		if ( $dsm_search_icon_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_icon_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_search_icon_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_icon_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_icon_padding'], $padding, $important ),
			)
		);

		if ( $dsm_search_icon_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_icon_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_search_icon_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-button',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_icon_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		// search field work
		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-search-container .dsm-mega-menu-search-box',
				'declaration' => 'margin-top: 20px;opacity: 0;',
			)
		);
		if ( 'horizontal' === $this->props['dsm_layout'] ) {

			if ( 'top' === $this->props['dsm_search_field_position'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-search-container .dsm-mega-menu-search-box',
						'declaration' => 'position: absolute;
										bottom: 100%;
										left: 50%;
										transform: translateX(-50%);
										margin-top: 20px;
										opacity: 0;
										z-index:99;',
					)
				);
			}

			if ( 'bottom' === $this->props['dsm_search_field_position'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-search-container .dsm-mega-menu-search-box',
						'declaration' => 'position: absolute;
											top: 100%;
											left: 50%;
											transform: translateX(-50%);
											margin-top: 20px;
											opacity: 0;
											z-index:99;',
					)
				);
			}

			if ( 'left' === $this->props['dsm_search_field_position'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-search-container .dsm-mega-menu-search-box',
						'declaration' => 'position: absolute;
										top: 0%;
										right: 100%;
										margin-top: 20px;
										opacity: 0;
										z-index:99;',
					)
				);
			}

			if ( 'right' === $this->props['dsm_search_field_position'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-search-container .dsm-mega-menu-search-box',
						'declaration' => 'position: absolute;
										  top: 0%;
										  left: 100%;
										  margin-top: 20px;
										  opacity: 0;
										  z-index:99;',
					)
				);
			}
		}

		if ( 'vertical' === $this->props['dsm_layout'] ) {

			if ( 'left' === $this->props['dsm_dropdown_position'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-search-container .dsm-mega-menu-search-box',
						'declaration' => 'position: absolute;
										  top: 100%;
										  left: 0%;
										  margin-top: 20px;
										  opacity: 0;
										  z-index:99;',
					)
				);
			}

			if ( 'right' === $this->props['dsm_dropdown_position'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-search-container',
						'declaration' => 'justify-content: flex-end;',
					)
				);

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.mobile-menu) .dsm-mega-menu-search-container .dsm-mega-menu-search-box',
						'declaration' => 'position: absolute;
										  top: 100%;
										  right: 0%;
										  margin-top: 20px;
										  opacity: 0;
										  z-index:99;',
					)
				);
			}
		}

		if ( $this->props['dsm_search_field_width'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_search_field_width'] ),
				)
			);
		}

		if ( $dsm_search_field_width_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_search_field_width_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_search_field_width_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_search_field_width_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_search_field_text_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input, %%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input::placeholder',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_search_field_text_color'] ),
				)
			);
		}

		if ( $dsm_search_field_text_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_search_field_text_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_search_field_text_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_search_field_text_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_search_field_text_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_search_field_text_bg_color'] ),
				)
			);
		}

		if ( $dsm_search_field_text_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_search_field_text_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_search_field_text_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_search_field_text_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_field_margin'], $margin, $important ),
			)
		);

		if ( $dsm_search_field_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_field_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_search_field_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_field_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_field_padding'], $padding, $important ),
			)
		);

		if ( $dsm_search_field_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_field_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_search_field_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-mega-menu-search-container .dsm-mega-menu-search-box .et_pb_menu__search-input',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_search_field_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( 'on' === $this->props['dsm_show_arrow'] ) {

			if ( $this->props['dsm_arrow_color'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container:before',
						'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_arrow_color'] ),
					)
				);
			}

			if ( $dsm_arrow_color_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container:before',
						'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_arrow_color_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_arrow_color_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-root-menu .dsm-mega-menu-item .dsm-submenu-container:before',
						'declaration' => sprintf( 'background: %1$s;', $this->props['dsm_arrow_color_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}
		}

		if ( $this->props['dsm_link_animation_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm_link_animation_effect_one  .dsm-mega-menu-link:before,
						                  %%order_class%% .dsm_link_animation_effect_two  .dsm-mega-menu-link:after,
										  %%order_class%% .dsm_link_animation_effect_three  .dsm-mega-menu-link:after,
										  %%order_class%% .dsm_link_animation_effect_four  .dsm-mega-menu-link:before,
										  %%order_class%% .dsm_link_animation_effect_four  .dsm-mega-menu-link:after,
										  %%order_class%% .dsm_link_animation_effect_five .dsm-mega-menu-link:before',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_link_animation_color'] ),
				)
			);
		}

		// logo styling.
		if ( '' === trim( $this->props['dsm_logo_url'] ) ) {

			if ( $this->props['dsm_logo_width'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-logo-wrap, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-wrap',
						'declaration' => sprintf( 'width: %1$s;', $this->props['dsm_logo_width'] ),
					)
				);
			}

			if ( $dsm_logo_width_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-logo-wrap, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-wrap',
						'declaration' => sprintf( 'width: %1$s;', $this->props['dsm_logo_width_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_logo_width_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-logo-wrap, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-wrap',
						'declaration' => sprintf( 'width: %1$s;', $this->props['dsm_logo_width_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.dsm-mega-menu-vertical-layout) .dsm-logo-wrap',
					'declaration' => 'margin-right: 30px;',
				)
			);
		}

		if ( '' !== trim( $this->props['dsm_logo_url'] ) ) {

			if ( $this->props['dsm_logo_width'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-logo-link, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-link',
						'declaration' => sprintf( 'width: %1$s;', $this->props['dsm_logo_width'] ),
					)
				);
			}

			if ( $dsm_logo_width_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-logo-link, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-link',
						'declaration' => sprintf( 'width: %1$s;', $this->props['dsm_logo_width_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_logo_width_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-logo-link, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-link',
						'declaration' => sprintf( 'width: %1$s;', $this->props['dsm_logo_width_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container:not(.dsm-mega-menu-vertical-layout) .dsm-logo-link',
					'declaration' => 'margin-right: 30px;',
				)
			);
		}

		if ( $this->props['dsm_logo_height'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-logo-wrap img, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-wrap img',
					'declaration' => sprintf( 'height : %1$s;', $this->props['dsm_logo_height'] ),
				)
			);
		}

		if ( $dsm_logo_height_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-logo-wrap img, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-wrap img',
					'declaration' => sprintf( 'height : %1$s;', $this->props['dsm_logo_height_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_logo_height_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container .dsm-logo-wrap img, %%order_class%% .dsm-mobile-menu-open-button-container .dsm-logo-wrap img',
					'declaration' => sprintf( 'height : %1$s;', $this->props['dsm_logo_height_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$this->generate_styles(
			array(
				'utility_arg'    => 'icon_font_family',
				'render_slug'    => $render_slug,
				'base_attr_name' => 'dsm_search_font_icon',
				'selector'       => '%%order_class%% .dsm_search_icon',
				'important'      => true,
				'processor'      => array(
					'ET_Builder_Module_Helper_Style_Processor',
					'process_extended_icon',
				),
			)
		);

		$this->generate_styles(
			array(
				'utility_arg'    => 'icon_font_family',
				'render_slug'    => $render_slug,
				'base_attr_name' => 'dsm_mobile_open_font_icon',
				'selector'       => '%%order_class%% .dsm_mobile_open_icon',
				'important'      => true,
				'processor'      => array(
					'ET_Builder_Module_Helper_Style_Processor',
					'process_extended_icon',
				),
			)
		);

		$this->generate_styles(
			array(
				'utility_arg'    => 'icon_font_family',
				'render_slug'    => $render_slug,
				'base_attr_name' => 'dsm_mobile_close_font_icon',
				'selector'       => '%%order_class%% .dsm_mobile_close_icon',
				'important'      => true,
				'processor'      => array(
					'ET_Builder_Module_Helper_Style_Processor',
					'process_extended_icon',
				),
			)
		);

		$search_icon = $multi_view->render_element(
			array(
				'tag'     => 'span',
				'content' => '{{dsm_search_font_icon}}',
				'attrs'   => array(
					'class' => 'dsm_search_icon',
				),
			)
		);

		$mobile_open_icon = $multi_view->render_element(
			array(
				'tag'     => 'span',
				'content' => '{{dsm_mobile_open_font_icon}}',
				'attrs'   => array(
					'class' => 'dsm_mobile_open_icon',
				),
			)
		);

		$mobile_close_icon = $multi_view->render_element(
			array(
				'tag'     => 'span',
				'content' => '{{dsm_mobile_close_font_icon}}',
				'attrs'   => array(
					'class' => 'dsm_mobile_close_icon',
				),
			)
		);

		// mobile menu styling work

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu nav',
				'declaration' => 'height: calc(75vh - 20px);
                                      overflow-y: scroll;',
				'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
			)
		);
		// ken fix tablet.
		if ( '' !== $this->props['dsm_logo'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mobile-menu-open-button-container',
					'declaration' => 'display:flex;
										  justify-content: space-between;
										  align-items:center;',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( '' === $this->props['dsm_logo'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mobile-menu-open-button-container',
					'declaration' => sprintf( 'display:flex; justify-content: %1$s;', 'dsm_hamburger_right' === $this->props['dsm_mobile_hamburger_alignment'] ? 'flex-end' : 'flex-start' ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-search-box',
				'declaration' => 'position: absolute; bottom:0; margin-top: 0px !important; opacity: 1 !important;',
				'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-search-box .et_pb_menu__search-input',
				'declaration' => 'width: 100% !important;',
				'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
			)
		);

		if ( $this->props['dsm_search_field_mobile_width'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-search-box',
					'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_search_field_mobile_width'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( 'left' === $this->props['dsm_search_field_mobile_alignment'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-search-box',
					'declaration' => 'left: 0% !important;',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( 'center' === $this->props['dsm_search_field_mobile_alignment'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-search-box',
					'declaration' => 'left: 50% !important; transform: translate(-50%);',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( 'right' === $this->props['dsm_search_field_mobile_alignment'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-search-box',
					'declaration' => 'right: 0% !important;',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $this->props['dsm_hamburger_icon_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mobile-menu-open-button-container .dsm-mega-menu-open-button .dsm_mobile_open_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_hamburger_icon_color'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $this->props['dsm_open_icon_font_size'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mobile-menu-open-button-container .dsm-mega-menu-open-button .dsm_mobile_open_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_open_icon_font_size'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $this->props['dsm_hamburger_icon_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mobile-menu-open-button-container .dsm-mega-menu-open-button',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_hamburger_icon_bg_color'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mobile-menu-open-button-container .dsm-mega-menu-open-button',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_hamburger_icon_margin'], $margin, $important ),
				'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),

			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mobile-menu-open-button-container .dsm-mega-menu-open-button',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_hamburger_icon_padding'], $padding, $important ),
				'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
			)
		);

		if ( 'left' === $this->props['dsm_mobile_container_alignment'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
					'declaration' => 'left: 0% !important;',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( 'center' === $this->props['dsm_mobile_container_alignment'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
					'declaration' => 'left: 50% !important; transform : translate(-50%) !important;',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( 'right' === $this->props['dsm_mobile_container_alignment'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
					'declaration' => 'right : 0 !important;',
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_mobile_container_margin'], $margin, $important ),
				'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),

			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_mobile_container_padding'], $padding, $important ),
				'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
			)
		);

		if ( $this->props['dsm_mobile_container_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
					'declaration' => sprintf( 'background: %1$s;', $this->props['dsm_mobile_container_bg_color'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $this->props['dsm_mobile_container_width'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
					'declaration' => sprintf( 'width: %1$s;', $this->props['dsm_mobile_container_width'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		$mobile_container_margin_convert_arr = explode( '|', $this->props['dsm_mobile_container_margin'] );
		$get_first_value                     = $mobile_container_margin_convert_arr[0];

		if ( '' !== $get_first_value && $this->props['dsm_mobile_container_height'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
					'declaration' => sprintf( 'height: calc(%1$s - %2$s) !important;', $this->props['dsm_mobile_container_height'], $get_first_value ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( '' === $get_first_value && $this->props['dsm_mobile_container_height'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu',
					'declaration' => sprintf( 'height: %1$s !important;', $this->props['dsm_mobile_container_height'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $this->props['dsm_close_icon_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-close-button .dsm_mobile_close_icon',
					'declaration' => sprintf( 'color: %1$s;', $this->props['dsm_close_icon_color'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $this->props['dsm_close_icon_font_size'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-close-button .dsm_mobile_close_icon',
					'declaration' => sprintf( 'font-size: %1$s;', $this->props['dsm_close_icon_font_size'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $this->props['dsm_close_icon_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-close-button',
					'declaration' => sprintf( 'background: %1$s;', $this->props['dsm_close_icon_bg_color'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-close-button',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_close_icon_margin'], $margin, $important ),
				'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),

			)
		);

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-close-button',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_close_icon_padding'], $padding, $important ),
				'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
			)
		);

		if ( $this->props['dsm_close_icon_top_position'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-close-button',
					'declaration' => sprintf( 'top: %1$s;', $this->props['dsm_close_icon_top_position'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $this->props['dsm_close_icon_left_position'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container.mobile-menu .dsm-mega-menu-close-button',
					'declaration' => sprintf( 'left: %1$s;', $this->props['dsm_close_icon_left_position'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		$logo_without_link = trim( '' === $this->props['dsm_logo_url'] ) && '' !== $this->props['dsm_logo'] ? sprintf( '<div class="dsm-logo-wrap"><img src="%1$s"/></div>', $this->props['dsm_logo'] ) : '';
		$logo_with_link    = trim( '' !== $this->props['dsm_logo_url'] ) && '' !== $this->props['dsm_logo'] ? sprintf( '<a class="dsm-logo-link" href="%2$s" %3$s><div class="dsm-logo-wrap"><img src="%1$s"/></div></a>', $this->props['dsm_logo'], $this->props['dsm_logo_url'], 'on' === $this->props['dsm_logo_url_new_window'] ? 'target="_blank" ' : '' ) : '';
		$is_logo_link      = '' !== trim( $this->props['dsm_logo_url'] ) ? $logo_with_link : $logo_without_link;

		if ( 'on' === get_option( 'smega_menu_dynamic_css' ) ) {
			add_filter( 'et_global_assets_list', array( $this, 'dsm_load_required_divi_assets' ), 10, 3 );
			add_filter( 'et_late_global_assets_list', array( $this, 'dsm_load_required_divi_assets' ), 10, 3 );
		}

		return sprintf(
			'<div class="dsm-mega-menu-container dsm-mega-menu-main-wrapper %6$s %9$s" data-showarrow="%7$s" data-dropdownanimation="%2$s" data-trigger="%3$s"> 
			    %13$s
			    <nav itemscope itemtype="http://schema.org/SiteNavigationElement">
				  <ul class="dsm-root-menu">%1$s</ul>
				 <div class="dsm-mega-menu-search-container">
				  %4$s
				  %5$s
				 </div>
				</nav>
		    </div>
			<div class="dsm-mobile-menu-open-button-container">
			       %15$s
			      <button class="dsm-mega-menu-open-button">%10$s</button>
				   %14$s
			</div> 
				<div class="dsm-mega-menu-container mobile-menu" data-entrance-mobile="%8$s" data-exit-mobile="%16$s" data-mobile_trigger="%12$s">
					<button class="dsm-mega-menu-close-button">%11$s</button>
					<nav itemscope itemtype="http://schema.org/SiteNavigationElement">
						<ul class="dsm-root-menu">
							%1$s
						</ul>
					</nav>
					<div class="dsm-mega-menu-search-container">
							%5$s
					</div>
				</div>
		    ',
			$this->props['content'],
			$this->props['dsm_dropdown_animation'],
			$this->props['dsm_trigger'],
			'on' === $this->props['dsm_show_search_icon'] ? sprintf( '<div class="dsm-mega-menu-search-button">%1$s</div>', $search_icon ) : '',
			'on' === $this->props['dsm_show_search_icon'] ? $this->get_search_form() : '',
			'vertical' === $this->props['dsm_layout'] ? 'dsm-mega-menu-vertical-layout' : '',
			$this->props['dsm_show_arrow'],
			$this->props['dsm_mobile_entrance_animation'],
			'none' !== $this->props['dsm_link_animation'] ? $this->props['dsm_link_animation'] : '',
			$mobile_open_icon,
			$mobile_close_icon,
			$this->props['dsm_mobile_trigger'],
			$is_logo_link,
			'dsm_hamburger_left' === $this->props['dsm_mobile_hamburger_alignment'] ? $is_logo_link : '',
			'dsm_hamburger_right' === $this->props['dsm_mobile_hamburger_alignment'] ? $is_logo_link : '',
			$this->props['dsm_mobile_exit_animation']
		);
	}

	public function multi_view_filter_value( $raw_value, $args, $multi_view ) {
		$name = isset( $args['name'] ) ? $args['name'] : '';
		$mode = isset( $args['mode'] ) ? $args['mode'] : '';

		if ( $raw_value && 'dsm_search_font_icon' === $name ) {
			return et_pb_get_extended_font_icon_value( $raw_value, true );
		}

		if ( $raw_value && 'dsm_mobile_open_font_icon' === $name ) {
			return et_pb_get_extended_font_icon_value( $raw_value, true );
		}

		if ( $raw_value && 'dsm_mobile_close_font_icon' === $name ) {
			return et_pb_get_extended_font_icon_value( $raw_value, true );
		}

		$fields_need_escape = array(
			'button_text',
		);

		if ( $raw_value && in_array( $name, $fields_need_escape, true ) ) {
			return $this->_esc_attr( $multi_view->get_name_by_mode( $name, $mode ), 'none', $raw_value );
		}

		return $raw_value;
	}

	/**
	 * Force load global styles.
	 *
	 * @param array $assets_list Current global assets on the list.
	 *
	 * @return array
	 */
	public function dsm_load_required_divi_assets( $assets_list, $assets_args, $instance ) {
		$assets_prefix  = et_get_dynamic_assets_path();
		$all_shortcodes = $instance->get_saved_page_shortcodes();

		$assets_list['dsm_mega_menu_animate'] = array(
			'css' => plugin_dir_url( __DIR__ ) . 'MegaMenu/animate.css',
		);

		$assets_list['dsm_mega_menu'] = array(
			'css' => plugin_dir_url( __DIR__ ) . 'MegaMenu/style.css',
		);
		if ( ! isset( $assets_list['et_icons_all'] ) ) {
			$assets_list['et_icons_all'] = array(
				'css' => "{$assets_prefix}/css/icons_all.css",
			);
		}

		if ( ! isset( $assets_list['et_icons_fa'] ) ) {
			$assets_list['et_icons_fa'] = array(
				'css' => "{$assets_prefix}/css/icons_fa_all.css",
			);
		}
		return $assets_list;
	}
}

new DSM_Mega_Menu();
