<?php
defined( 'ABSPATH' ) || exit;

class WACU_Admin_Enqueue {

	public function __construct() {
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ), 200 );
	}

	public function enqueue_scripts( $hook ) {

		if ( ! in_array( $hook, $this->is_plugin_admin_page() ) ) {
			return;
		}

		wp_enqueue_script( 'jquery-ui-sortable' );

		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'wp-color-picker' );

		wp_enqueue_style( 'wacu-select2', WACU_PLUGIN_URL . 'assets/libraries/select2/select2.min.css', array(), '4.1.0-rc.0' );
		wp_enqueue_script( 'wacu-select2', WACU_PLUGIN_URL . 'assets/libraries/select2/select2.min.js', array(), '4.1.0-rc.0', true );

		wp_enqueue_style( 'wacu-admin-style', WACU_PLUGIN_URL . 'assets/css/wacu-admin-style.css', array(), WACU_PLUGIN_VER );
		wp_enqueue_script( 'wacu-admin-script', WACU_PLUGIN_URL . 'assets/js/wacu-admin-script.js', array(), WACU_PLUGIN_VER, true );

		wp_localize_script(
			'wacu-admin-script',
			'wacuAdminObj', // Object name
			apply_filters(
				'wacu_admin_localize_script',
				array(
					'ajax_url'  => admin_url( 'admin-ajax.php' ),
				)
			)
		);
	}

	public function is_plugin_admin_page() {
		$admin_screens = array(
			'toplevel_page_wp-any-contact-us',
			'wp-any-contact-us_page_wp-any-contact-us_social-contacts',
			'wp-any-contact-us_page_wp-any-contact-us_smart-messages',
			'wp-any-contact-us_page_wp-any-contact-us_shortcode',
			'wp-any-contact-us_page_wp-any-contact-us_gdpr',
			'wp-any-contact-us_page_wp-any-contact-us_plugin-support',
		);

		/**
		 * Filter plugin admin screens.
		 *
		 * @since 2.0.0
		 *
		 * @param array $admin_screens Plugin admin screens or page.
		 */
		$admin_screens = apply_filters( 'wacu_plugin_admin_screens', $admin_screens );

		return $admin_screens;
	}

}

$wacu_admin_enqueue = new WACU_Admin_Enqueue;
