<?php
defined( 'ABSPATH' ) || exit;

class WACU_Admin_Notice {

	public function __construct() {
		add_action( 'admin_notices', array( $this, 'welcome_2_0' ) );
		add_action( 'admin_init', array( $this, 'dismiss_welcome_2_0_notice' ) );
	}

	public function welcome_2_0() {
		if ( 'yes' === get_option( 'wacu_dismiss_welcome_2_0_notice' ) ) {
			return;
		}
		if ( ! get_option( WACU_PLUGIN_PREFIX . 'license_key' ) ) {
			return;
		}
		?>
			<div class="notice notice-success is-dismissible">
				<h3><?php esc_html_e( 'Thank you for choosing the WordPress Any Contact Us. :)', 'wp-any-contact-us' ); ?></h3>
				<p><?php esc_html_e( 'We rapidly improving our plugin by fixing the major and minor bugs. Please support us for the best.', 'wp-any-contact-us' ); ?></p>

				<h4><?php echo esc_html( sprintf( __( 'Change Log - Version %s', 'wp-any-contact-us' ), WACU_PLUGIN_VER ) ); ?></h4>
				<p><?php echo wp_kses_post( __( 'Note: If you upgrade the plugin from <strong>version 1.8 or older</strong> then please do the following changes or if you installed the plugin first time then you do not need to do the following change :)', 'wp-any-contact-us' ) ); ?></p>
				<p><?php esc_html_e( '1: If you are using WPML for multi languages then please check and re-translate the dynamic strings.', 'wp-any-contact-us' ); ?></p>
				<p><?php esc_html_e( '2: Cross check your plugin settings again.', 'wp-any-contact-us' ); ?></p>
				<p>
					<a href="https://codecanyon.net/item/wordpress-any-contact-us/23280292/support" target="_blank" class="button button-primary"><?php esc_html_e( 'I found a bug!', 'wp-any-contact-us' ); ?></a>
					<a href="https://codecanyon.net/item/wordpress-any-contact-us/23280292/support" target="_blank" class="button"><?php esc_html_e( 'I need support', 'wp-any-contact-us' ); ?></a>
					<a href="<?php echo wp_nonce_url( '?wacu_action=dismiss_welcome_2_0_notice' ); ?>" class="button button-link-delete"><?php esc_html_e( 'Dismiss notice', 'wp-any-contact-us' ); ?></a>
				</p>
			</div>
		<?php
	}

	public function dismiss_welcome_2_0_notice() {
		if ( isset( $_GET['wacu_action'] )
		&& 'dismiss_welcome_2_0_notice' === $_GET['wacu_action']
		&& wp_verify_nonce( $_GET['_wpnonce'] ) ) {
			update_option( 'wacu_dismiss_welcome_2_0_notice', 'yes' );
			wp_safe_redirect( wp_get_referer() );
		}
	}


}

new WACU_Admin_Notice;
