<?php
defined( 'ABSPATH' ) || exit;

class WACU_Admin_Save_Settings {

	public function __construct() {
		add_action( 'admin_init', array( $this, 'add_social_contact' ) );
		add_action( 'admin_init', array( $this, 'edit_social_contact' ) );
		add_action( 'admin_init', array( $this, 'delete_all_social_contact' ) );
		add_action( 'admin_init', array( $this, 'add_smart_message' ) );
		add_action( 'admin_init', array( $this, 'edit_smart_message' ) );

		if ( is_admin() && defined( 'DOING_AJAX' ) && DOING_AJAX ) {
			add_action( 'wp_ajax_wacu_delete_social_contact', array( $this, 'delete_social_contact' ) );
			add_action( 'wp_ajax_wacu_disable_social_contact', array( $this, 'disable_social_contact' ) );
			add_action( 'wp_ajax_wacu_enable_social_contact', array( $this, 'enable_social_contact' ) );
			add_action( 'wp_ajax_wacu_edit_social_contact_form', array( $this, 'edit_social_contact_form' ) );
			add_action( 'wp_ajax_wacu_sort_social_contacts', array( $this, 'sort_social_contacts' ) );
			add_action( 'wp_ajax_wacu_edit_smart_message_form', array( $this, 'edit_smart_message_form' ) );
			add_action( 'wp_ajax_wacu_delete_smart_message', array( $this, 'delete_smart_message' ) );
			add_action( 'wp_ajax_wacu_disable_smart_message', array( $this, 'disable_smart_message' ) );
			add_action( 'wp_ajax_wacu_enable_smart_message', array( $this, 'enable_smart_message' ) );
			add_action( 'wp_ajax_wacu_sort_smart_messages', array( $this, 'sort_smart_messages' ) );
		}
	}

	public function add_social_contact() {
		if ( isset( $_POST['wacu_social_contact'] )
			&& wp_verify_nonce( $_POST['wacu_add_social_contact_security'], 'wacu_add_social_contact_submit' ) ) {
			$post_data = stripslashes_deep( $_POST['wacu_social_contact'] );
			$post_data = apply_filters(
				'wacu_' . __FUNCTION__,
				array(
					'title'         => $post_data['title'],
					'description'   => $post_data['description'],
					'icon'          => $post_data['icon'],
					'icon_color'    => $post_data['icon_color'],
					'device'        => $post_data['device'],
					'register_only' => $post_data['register_only'],
					'type'          => $post_data['type'],
					'link'          => $post_data['link'],
					'target'        => $post_data['target'],
					'content'       => $post_data['content'],
					'integration'   => $post_data['integration'],
				)
			);

			// Gather post data.
			$social_contact_post = array(
				'post_title'    => $post_data['title'],
				'post_content'  => $post_data['description'],
				'post_status'   => 'publish',
				'post_type'     => 'wacu_social_contact',
				'post_author'   => get_current_user_id(),
			);

			// Insert the post into the database.
			$post_id = wp_insert_post( $social_contact_post );

			add_post_meta( $post_id, 'icon', $post_data['icon'], true );
			add_post_meta( $post_id, 'icon_color', $post_data['icon_color'], true );
			add_post_meta( $post_id, 'device', $post_data['device'], true );
			add_post_meta( $post_id, 'register_only', $post_data['register_only'], true );
			add_post_meta( $post_id, 'type', $post_data['type'], true );
			add_post_meta( $post_id, 'link', $post_data['link'], true );
			add_post_meta( $post_id, 'target', $post_data['target'], true );
			add_post_meta( $post_id, 'content', $post_data['content'], true );
			add_post_meta( $post_id, 'integration', $post_data['integration'], true );
			add_post_meta( $post_id, 'status', '1', true );
			add_post_meta( $post_id, 'position', '0', true );

			delete_transient( 'wacu_social_contacts' );

			wp_safe_redirect( admin_url( 'admin.php?page=wp-any-contact-us_social-contacts' ) );
			exit;
		}
	}

	public function edit_social_contact() {
		if ( isset( $_POST['wacu_social_contact'] )
			&& wp_verify_nonce( $_POST['wacu_edit_social_contact_security'], 'wacu_edit_social_contact_submit' ) ) {
			$id        = $_POST['wacu_social_contact']['id'];
			$post_data = stripslashes_deep( $_POST['wacu_social_contact'] );
			$post_data = apply_filters(
				'wacu_' . __FUNCTION__,
				array(
					'title'         => $post_data['title'],
					'description'   => $post_data['description'],
					'icon'          => $post_data['icon'],
					'icon_color'    => $post_data['icon_color'],
					'device'        => $post_data['device'],
					'register_only' => $post_data['register_only'],
					'type'          => $post_data['type'],
					'link'          => $post_data['link'],
					'target'        => $post_data['target'],
					'content'       => $post_data['content'],
					'integration'   => $post_data['integration'],
				)
			);

			$post_id = wp_update_post( array(
				'ID'           => $id,
				'post_title'   => $post_data['title'],
				'post_content' => $post_data['description'],
			) );

			update_post_meta( $post_id, 'icon', $post_data['icon'] );
			update_post_meta( $post_id, 'icon_color', $post_data['icon_color'] );
			update_post_meta( $post_id, 'device', $post_data['device'] );
			update_post_meta( $post_id, 'register_only', $post_data['register_only'] );
			update_post_meta( $post_id, 'type', $post_data['type'] );
			update_post_meta( $post_id, 'link', $post_data['link'] );
			update_post_meta( $post_id, 'target', $post_data['target'] );
			update_post_meta( $post_id, 'content', $post_data['content'] );
			update_post_meta( $post_id, 'integration', $post_data['integration'], true );

			delete_transient( 'wacu_social_contacts' );

			wp_safe_redirect( admin_url( 'admin.php?page=wp-any-contact-us_social-contacts' ) );
			exit;
		}
	}

	public function sort_social_contacts() {
		if ( ! isset( $_POST['social_contact_ids'] ) ) {
			return;
		}

		global $wpdb;

		$ids = $_POST['social_contact_ids'];

		foreach ( $ids as $id_key => $id ) {
			update_post_meta( $id, 'position', ( $id_key + 1 ) );
		}

		delete_transient( 'wacu_social_contacts' );

		wp_die();
	}

	public function edit_social_contact_form() {
		$id             = $_POST['id'];
		$social_contact = wacu_get_social_contact( $id );

		require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-edit-social-contact.php';
		wp_die();
	}

	public function edit_smart_message_form() {
		$id            = $_POST['id'];
		$smart_message = wacu_get_smart_message( $id );

		require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-edit-smart-message.php';
		wp_die();
	}

	public function disable_social_contact() {
		if ( ! is_admin() ) {
			return;
		}
		if ( isset( $_POST['action'] ) && 'wacu_disable_social_contact' === $_POST['action'] ) {
			$id = $_POST['id'];
			update_post_meta( $id, 'status', '0' );
			delete_transient( 'wacu_social_contacts' );
		}

		wp_die();
	}

	public function enable_social_contact() {
		if ( ! is_admin() ) {
			return;
		}
		if ( isset( $_POST['action'] ) && 'wacu_enable_social_contact' === $_POST['action'] ) {
			$id = $_POST['id'];
			update_post_meta( $id, 'status', '1' );
			delete_transient( 'wacu_social_contacts' );
		}

		wp_die();
	}

	public function add_smart_message() {
		if ( isset( $_POST['wacu_add_smart_message'] )
			&& wp_verify_nonce( $_POST['wacu_add_smart_message_security'], 'wacu_add_smart_message_submit' ) ) {
			$post_data = stripslashes_deep( $_POST['wacu_add_smart_message'] );
			$post_data = apply_filters(
				'wacu_' . __FUNCTION__,
				array(
					'message'   => $post_data['message'],
					'post_type' => $post_data['post_type'],
				)
			);

			// Gather post data.
			$smart_message_post = array(
				'post_title'    => 'Smart Message',
				'post_content'  => $post_data['message'],
				'post_status'   => 'publish',
				'post_type'     => 'wacu_smart_message',
				'post_author'   => get_current_user_id(),
			);

			// Insert the post into the database.
			$post_id = wp_insert_post( $smart_message_post );

			add_post_meta( $post_id, 'post_type', $post_data['post_type'], true );
			add_post_meta( $post_id, 'status', '1', true );
			add_post_meta( $post_id, 'position', '0', true );

			delete_transient( 'wacu_smart_messages' );

			wp_safe_redirect( admin_url( 'admin.php?page=wp-any-contact-us_smart-messages' ) );
			exit;
		}
	}

	public function edit_smart_message() {
		if ( isset( $_POST['wacu_edit_smart_message'] )
			&& wp_verify_nonce( $_POST['wacu_edit_smart_message_security'], 'wacu_edit_smart_message_submit' ) ) {
			$id        = $_POST['wacu_edit_smart_message']['id'];
			$post_data = stripslashes_deep( $_POST['wacu_edit_smart_message'] );
			$post_data = apply_filters(
				'wacu_' . __FUNCTION__,
				array(
					'message' => $post_data['message'],
					'post_type' => $post_data['post_type'],
				)
			);

			$post_id = wp_update_post( array(
				'ID'           => $id,
				'post_content' => $post_data['message'],
			) );

			update_post_meta( $post_id, 'post_type', $post_data['post_type'] );

			delete_transient( 'wacu_smart_messages' );

			wp_safe_redirect( admin_url( 'admin.php?page=wp-any-contact-us_smart-messages' ) );
			exit;
		}
	}

	public function sort_smart_messages() {
		if ( ! isset( $_POST['smart_message_ids'] ) ) {
			return;
		}

		global $wpdb;

		$ids = $_POST['smart_message_ids'];

		for ( $i = 0; $i < count( $ids ); $i++ ) {
			update_post_meta( $ids[$i], 'position', ( $i + 1 ) );
		}

		delete_transient( 'wacu_smart_messages' );

		wp_die();
	}

	/**
	 * Delete smart message through AJAX
	 */
	public function delete_smart_message() {
		if ( ! is_admin() ) {
			return;
		}
		if ( isset( $_GET['wacu_delete_smart_message'] ) ) {
			$response = array(
				'status' => false,
			);
			$smart_message_id = $_GET['wacu_delete_smart_message'];

			if ( wp_delete_post( $smart_message_id ) ) {
				$response['status'] = true;
			}

			delete_transient( 'wacu_smart_messages' );

			echo wp_json_encode( $response );
			wp_die();
		}
	}

	public function disable_smart_message() {
		if ( ! is_admin() ) {
			return;
		}
		if ( isset( $_POST['action'] ) && 'wacu_disable_smart_message' === $_POST['action'] ) {
			$id = $_POST['id'];
			update_post_meta( $id, 'status', '0' );
		}

		delete_transient( 'wacu_smart_messages' );

		wp_die();
	}

	public function enable_smart_message() {
		if ( ! is_admin() ) {
			return;
		}
		if ( isset( $_POST['action'] ) && 'wacu_enable_smart_message' === $_POST['action'] ) {
			$id = $_POST['id'];
			update_post_meta( $id, 'status', '1' );
		}

		delete_transient( 'wacu_smart_messages' );

		wp_die();
	}

	/**
	 * Delete social contact through AJAX
	 */
	public function delete_social_contact() {
		if ( ! is_admin() ) {
			return;
		}
		if ( isset( $_GET['wacu_delete_socail_contact'] ) ) {
			$response = array(
				'status' => false,
			);
			$social_contact_id = $_GET['wacu_delete_socail_contact'];

			if ( wp_delete_post( $social_contact_id ) ) {
				$response['status'] = true;
			}

			delete_transient( 'wacu_social_contacts' );

			echo wp_json_encode( $response );
			wp_die();
		}
	}

	public function delete_all_social_contact() {
		if ( isset( $_GET['wacu_delete_all_socail_contact'] )
			&& 'yes' == $_GET['wacu_delete_all_socail_contact']
			&& wp_verify_nonce( $_GET['_wpnonce'] ) ) {

			$social_contacts = wacu_get_social_contacts();

			foreach ( $social_contacts as $sc ) {
				wp_delete_post( $sc['id'] );
			}

			delete_transient( 'wacu_social_contacts' );

			wp_safe_redirect( admin_url( 'admin.php?page=wp-any-contact-us_social-contacts' ) );
			exit;
		}
	}
}

new WACU_Admin_Save_Settings;
