<?php
defined( 'ABSPATH' ) || exit;

class WACU_Admin_Settings {

	public function __construct() {
		add_action( 'admin_init', array( $this, 'add_settings_section' ) );
		add_action( 'admin_init', array( $this, 'register_settings' ) );
	}

	public function add_settings_section() {
		add_settings_section(
			'wacu_appearance_setting',
			'',
			array( $this, 'appearance_setting' ),
			'wacu_appearance_setting_page'
		);
		add_settings_section(
			'wacu_basic_setting',
			'',
			array( $this, 'basic_setting' ),
			'wacu_basic_setting_page'
		);
		add_settings_section(
			'wacu_email_us_setting',
			'',
			array( $this, 'email_us_setting' ),
			'wacu_email_us_setting_page'
		);
		add_settings_section(
			'wacu_schedule_call_setting',
			'',
			array( $this, 'schedule_call_setting' ),
			'wacu_schedule_call_setting_page'
		);
		add_settings_section(
			'wacu_smart_popup_setting',
			'',
			array( $this, 'smart_popup_setting' ),
			'wacu_smart_popup_setting_page'
		);
		add_settings_section(
			'wacu_integrations_setting',
			'',
			array( $this, 'integrations_setting' ),
			'wacu_integrations_setting_page'
		);
		add_settings_section(
			'wacu_text_setting',
			'',
			array( $this, 'text_setting_page' ),
			'wacu_text_setting_page'
		);
	}

	public function register_settings() {
		register_setting( 'wacu_appearance_settings_option_group', 'wacu_appearance_settings', array( $this, 'appearance_setting_sanitize' ) );
		register_setting( 'wacu_basic_settings_option_group', 'wacu_basic_settings', array( $this, 'basic_setting_sanitize' ) );
		register_setting( 'wacu_email_us_settings_option_group', 'wacu_email_us_settings', array( $this, 'email_us_setting_sanitize' ) );
		register_setting( 'wacu_schedule_call_settings_option_group', 'wacu_schedule_call_settings', array( $this, 'schedule_call_setting_sanitize' ) );
		register_setting( 'wacu_gdpr_settings_option_group', 'wacu_gdpr_settings', array( $this, 'gdpr_setting_sanitize' ) );
		register_setting( 'wacu_smart_popup_settings_option_group', 'wacu_smart_popup_settings', array( $this, 'smart_popup_setting_sanitize' ) );
		register_setting( 'wacu_integrations_settings_option_group', 'wacu_integration_settings', array( $this, 'integration_setting_sanitize' ) );
		register_setting( 'wacu_text_settings_option_group', 'wacu_text_settings', array( $this, 'text_setting_sanitize' ) );
		register_setting( 'wacu_grecaptcha_settings_option_group', 'wacu_grecaptcha_settings', array( $this, 'grecaptcha_settings' ) );
	}

	public function appearance_setting() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/settings/appearance.php';
	}

	public function basic_setting() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/settings/basic-settings.php';
	}

	public function email_us_setting() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/settings/email-us.php';
	}

	public function schedule_call_setting() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/settings/schedule-call.php';
	}

	public function smart_popup_setting() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/settings/smart-popup.php';
	}

	public function integrations_setting() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/settings/integrations.php';
	}

	public function text_setting_page() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/settings/text.php';
	}

	public function appearance_setting_sanitize( $input ) {
		$input['background_color']  = sanitize_hex_color( $input['background_color'] );
		$input['text_color']        = sanitize_hex_color( $input['text_color'] );
		$input['widget_location']   = sanitize_text_field( $input['widget_location'] );
		$input['trigger_type']      = sanitize_key( $input['trigger_type'] );
		$input['trigger_text']      = sanitize_text_field( $input['trigger_text'] );
		$input['trigger_size']      = absint( $input['trigger_size'] );
		$input['trigger_icon_size'] = absint( $input['trigger_icon_size'] );
		$input['trigger_offset_x']  = absint( $input['trigger_offset_x'] );
		$input['trigger_offset_y']  = absint( $input['trigger_offset_y'] );
		$input['trigger_icon']      = sanitize_text_field( $input['trigger_icon'] );
		$input['trigger_effect']    = sanitize_key( $input['trigger_effect'] );
		$input['trigger_animation'] = isset( $input['trigger_animation'] ) ? 'yes' : 'no';

		return $input;
	}

	public function basic_setting_sanitize( $input ) {
		$input['widget_status']           = isset( $input['widget_status'] ) ? 'yes' : 'no';
		$input['display_on_mobile']       = isset( $input['display_on_mobile'] ) ? 'yes' : 'no';
		$input['display_on_desktop']      = isset( $input['display_on_desktop'] ) ? 'yes' : 'no';
		$input['filter_by_everywhere']    = isset( $input['filter_by_everywhere'] ) ? 'yes' : 'no';
		$input['filter_include_by_page']  = isset( $input['filter_include_by_page'] ) ? (array) $input['filter_include_by_page'] : array();
		$input['filter_by_regester_user'] = isset( $input['filter_by_regester_user'] ) ? 'yes' : 'no';
		$input['custom_css']              = wp_kses_post( $input['custom_css'] );

		return $input;
	}

	public function email_us_setting_sanitize( $input ) {
		$input['label_full_name']     = sanitize_text_field( $input['label_full_name'] );
		$input['label_email_address'] = sanitize_text_field( $input['label_email_address'] );
		$input['label_email_message'] = sanitize_text_field( $input['label_email_message'] );
		$input['label_button']        = sanitize_text_field( $input['label_button'] );
		$input['email_subject']       = sanitize_text_field( $input['email_subject'] );
		$input['email_body']          = wp_kses_post( $input['email_body'] );
		$input['email_to']            = sanitize_text_field( $input['email_to'] );
		$input['email_cc']            = sanitize_text_field( $input['email_cc'] );
		$input['email_bcc']           = sanitize_text_field( $input['email_bcc'] );
		$input['email_from_name']     = sanitize_text_field( $input['email_from_name'] );
		$input['email_from_email']    = sanitize_email( $input['email_from_email'] );
		$input['thank_you_message']   = wp_kses_post( $input['thank_you_message'] );
		$input['grecaptcha']          = isset( $input['grecaptcha'] ) ? 'yes' : 'no';

		return $input;
	}

	public function schedule_call_setting_sanitize( $input ) {
		$input['field_country']         = isset( $input['field_country'] ) ? 'yes' : 'no';
		$input['field_schedule_time']   = isset( $input['field_schedule_time'] ) ? 'yes' : 'no';
		$input['field_message']         = isset( $input['field_message'] ) ? 'yes' : 'no';
		$input['label_full_name']       = sanitize_text_field( $input['label_full_name'] );
		$input['label_country']         = sanitize_text_field( $input['label_country'] );
		$input['label_callback_number'] = sanitize_text_field( $input['label_callback_number'] );
		$input['label_schedule_time']   = sanitize_text_field( $input['label_schedule_time'] );
		$input['label_message']         = sanitize_text_field( $input['label_message'] );
		$input['label_button']          = sanitize_text_field( $input['label_button'] );
		$input['email_subject']         = sanitize_text_field( $input['email_subject'] );
		$input['email_body']            = wp_kses_post( $input['email_body'] );
		$input['email_to']              = sanitize_text_field( $input['email_to'] );
		$input['email_cc']              = sanitize_text_field( $input['email_cc'] );
		$input['email_bcc']             = sanitize_text_field( $input['email_bcc'] );
		$input['email_from_name']       = sanitize_text_field( $input['email_from_name'] );
		$input['email_from_email']      = sanitize_email( $input['email_from_email'] );
		$input['thank_you_message']     = wp_kses_post( $input['thank_you_message'] );
		$input['grecaptcha']            = isset( $input['grecaptcha'] ) ? 'yes' : 'no';

		return $input;
	}

	public function gdpr_setting_sanitize( $input ) {
		$input['status']       = isset( $input['status'] ) ? 'yes' : 'no';
		$input['message']      = sanitize_textarea_field( $input['message'] );
		$input['privacy_page'] = absint( $input['privacy_page'] );
		$input['location']     = sanitize_key( $input['location'] );

		return $input;
	}

	public function smart_popup_setting_sanitize( $input ) {
		$input['status']       = isset( $input['status'] ) ? 'yes' : 'no';
		$input['delay']        = absint( $input['delay'] );
		$input['interval']     = absint( $input['interval'] );
		$input['interval']     = absint( $input['interval'] );
		$input['typing_time']  = absint( $input['typing_time'] );
		$input['message_time'] = absint( $input['message_time'] );

		return $input;
	}

	public function grecaptcha_settings( $input ) {
		$input['v2_site_key']   = sanitize_text_field( $input['v2_site_key'] );
		$input['v2_secret_key'] = sanitize_text_field( $input['v2_secret_key'] );

		return $input;
	}

	public function integration_setting_sanitize( $input ) {
		$input['facebook_customer_chat']['status']           = isset( $input['facebook_customer_chat']['status'] ) ? 'yes' : 'no';
		$input['facebook_customer_chat']['page_id']          = sanitize_text_field( $input['facebook_customer_chat']['page_id'] );
		$input['facebook_customer_chat']['background_color'] = sanitize_hex_color( $input['facebook_customer_chat']['background_color'] );

		// Twak.to
		$input['tawk_to']['status']      = isset( $input['tawk_to']['status'] ) ? 'yes' : 'no';
		$input['tawk_to']['site_id']     = sanitize_text_field( $input['tawk_to']['site_id'] );
		$input['tawk_to']['widget_name'] = sanitize_text_field( $input['tawk_to']['widget_name'] );

		//WordPress WhatsApp Support
		$input['wordpress_whatsapp_support']['status'] = isset( $input['wordpress_whatsapp_support']['status'] ) ? 'yes' : 'no';

		return $input;
	}

	public function text_setting_sanitize( $input ) {
		$input['header_text'] = sanitize_text_field( $input['header_text'] );

		return $input;
	}
}

$wacu_admin_settings = new WACU_Admin_Settings;
