<?php defined( 'ABSPATH' ) || exit; ?>
<div class="wrap">
	<h1><?php esc_attr_e( 'Social Contacts', 'wp-any-contact-us' ); ?> <a class="button button-primary" href="javascript:;" data-wacu-model-trigger="add-social-contact"><?php esc_html_e( 'Add Social Contact', 'wp-any-contact-us' ); ?></a></h1>
	<hr>

	<table class="wp-list-table widefat striped" id="wacu-admin-social-contact-table">
		<thead>
			<tr>
				<th scope="col" class="manage-column column-name column-primary">
					<?php esc_html_e( 'Position', 'wp-any-contact-us' ) ?>
				</th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Icon', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Color', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Title', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Type', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Shortcode', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Target', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Device', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Users', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Status', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Action', 'wp-any-contact-us' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php if ( wacu_get_social_contacts() ) : ?>
				<?php foreach ( wacu_get_social_contacts() as $sc ) : ?>
					<tr data-wacu-sc-id="<?php echo intval( $sc['id'] ); ?>">
						<td class="wacu-sc-position">
							<div><?php echo WACU_Icon::get( 'arrows-alt-v' ); ?></div>
						</td>
						<td class="wacu-sc-icon">
							<div style="color: <?php echo esc_html( $sc['icon_color'] ); ?>;">
							<?php if ( $icon = WACU_Icon::get( $sc['icon'] ) ): ?>
								<?php echo $icon; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							<?php else: ?>
								<?php echo wp_kses_post( $sc['icon'] ); ?>
							<?php endif; ?>
							</div>
						<td class="wacu-sc-color">
							<div style="background-color: <?php echo esc_html( $sc['icon_color'] ); ?>;" data-wacu-tooltip="<?php echo esc_attr( $sc['icon_color'] ); ?>"></div>
						</td>
						<td class="wacu-sc-title"><?php echo esc_html( $sc['title'] ); ?></td>
						<td class="wacu-sc-type">
							<?php if ( 1 == $sc['type'] ): ?>
								<?php esc_html_e( 'Link', 'wp-any-contact-us' ) ?> <a href="<?php echo wp_kses_post( $sc['link'] ); ?>"><?php echo wp_kses_post( $sc['link'] ); ?></a>
							<?php elseif( 2 == $sc['type'] ): ?>
								<?php esc_html_e( 'HTML/Shortcode', 'wp-any-contact-us' ) ?>
							<?php elseif( 3 == $sc['type'] ): ?>
								<?php esc_html_e( 'Integration', 'wp-any-contact-us' ) ?>
							<?php endif; ?>
						</td>
						<td class="wacu-sc-shortcode">
							<?php if ( 1 == $sc['type'] || 3 == $sc['type'] ): ?>
								<input type="text" value="[wacu_button id='<?php echo absint( $sc['id'] ); ?>']" readonly>
							<?php endif; ?>
						</td>
						<td class="wacu-sc-target <?php echo ( '_self' == $sc['target'] ) ? 'disable' : ''; ?>">
							<div>
								<?php echo WACU_Icon::get( 'external-link-alt' ); ?>
							</div>
						</td>
						<td class="wacu-sc-device">
							<?php if ( 0 == $sc['device'] ): // No Where ?>
								<span class="wacu-sc-device__ban"><?php echo WACU_Icon::get( 'ban' ); ?></span>
							<?php elseif ( 1 == $sc['device'] ): // On Mobile Only ?>
								<span class="wacu-sc-device__mobile"><?php echo WACU_Icon::get( 'mobile-alt' ); ?></span>
							<?php elseif ( 2 == $sc['device'] ): // On Desktop Only ?>
								<span class="wacu-sc-device__desktop"><?php echo WACU_Icon::get( 'desktop' ); ?></span>
							<?php elseif ( 3 == $sc['device'] ): // On All Devices ?>
								<span class="wacu-sc-device__mobile"><?php echo WACU_Icon::get( 'mobile-alt' ); ?></span>
								<span class="wacu-sc-device__desktop"><?php echo WACU_Icon::get( 'desktop' ); ?></span>
							<?php endif; ?>
						</td>
						<td class="wacu-sc-register-only">
							<?php if ( 0 == $sc['register_only'] ): // All Users ?>
								<?php esc_html_e( 'All Users', 'wp-any-contact-us' ); ?>
							<?php elseif ( 1 == $sc['register_only'] ): // Register Users ?>
								<?php esc_html_e( 'Register Users', 'wp-any-contact-us' ); ?>
							<?php endif; ?>
						</td>
						<td class="wacu-sc-status">
							<div
								data-wacu-disable-social-contact="<?php echo absint( $sc['id'] ); ?>"
								data-wacu-tooltip="<?php esc_html_e( 'Click to disable', 'wp-any-contact-us' ) ?>"
								style="color: #455a64; <?php echo ( 1 == $sc['status'] ) ? 'display: block;' : 'display: none'; ?>">
								<?php echo WACU_Icon::get( 'eye' ); ?>
							</div>
							<div
								data-wacu-enable-social-contact="<?php echo absint( $sc['id'] ); ?>"
								data-wacu-tooltip="<?php esc_html_e( 'Click to enable', 'wp-any-contact-us' ) ?>"
								style="color: #b3c9d5; <?php echo ( 0 == $sc['status'] ) ? 'display: block;' : 'display: none'; ?>">
								<?php echo WACU_Icon::get( 'eye-slash' ); ?>
							</div>
						</td>
						<td class="wacu-sc-action">
							<a
								href="javascript:;"
								data-wacu-model-trigger="edit-social-contact"
								data-wacu-edit-social-contact="<?php echo absint( $sc['id'] ); ?>"
								data-wacu-tooltip="<?php esc_attr_e( 'Edit', 'wp-any-contact-us' ); ?>">
								<?php echo WACU_Icon::get( 'edit' ); ?>
							</a>
							<a
								href="javascript:;"
								onclick="return confirm( '<?php esc_html_e( 'Are you sure to delete this item?', 'wp-any-contact-us' ); ?>' )"
								data-wacu-delete-social-contact="<?php echo absint( $sc['id'] ); ?>"
								data-wacu-tooltip="<?php esc_attr_e( 'Delete', 'wp-any-contact-us' ); ?>">
								<?php echo WACU_Icon::get( 'trash' ); ?>
							</a>
						</td>
					</tr>
				<?php endforeach;?>
			<?php endif; ?>
		</tbody>
		<tfoot>
			<tr>
				<th scope="col" class="manage-column column-name column-primary"><?php esc_html_e( 'Position', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Icon', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Color', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Title', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Type', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Shortcode', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Target', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Device', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Users', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Status', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Action', 'wp-any-contact-us' ); ?></th>
			</tr>
		</tfoot>
	</table>
	<p>
		<a
			class="button-link-delete"
			onclick="return confirm( '<?php esc_html_e( 'Are you sure to delete all items?', 'wp-any-contact-us' ); ?>' )"
			href="<?php echo wp_nonce_url( '?wacu_delete_all_socail_contact=yes' ); ?>">
			<?php esc_html_e( 'Delete all social contacts', 'wp-any-contact-us' ); ?>
		</a>
	</p>
</div>

<!-- Add social contact popup -->
<?php require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-add-social-contact.php'; ?>
<!-- .Add social contact popup -->

<div class="wacu-model" data-wacu-modal="edit-social-contact">
	<div class="wacu-modal-content">
		<div class="wacu-modal-header">
			<?php esc_html_e( 'Edit Social Contact', 'wp-any-contact-us' ); ?>
		</div>
		<div class="wacu-modal-body" id="edit-social-contact">
			<div class="wacu-folding-cube">
				<div class="wacu-cube1 wacu-cube"></div>
				<div class="wacu-cube2 wacu-cube"></div>
				<div class="wacu-cube4 wacu-cube"></div>
				<div class="wacu-cube3 wacu-cube"></div>
			</div>
		</div>
	</div>
</div>
