<?php
defined( 'ABSPATH' ) || exit;

final class WACU_Init {

	/**
	 * Init
	 */
	function init() {
		$instance = new self;

		// Set up localisation.
		$this->load_plugin_textdomain();
		$this->init_hooks();
		$this->load_files();
	}

	public function init_hooks() {
		// Plugin page setting link on "Install plugin page"
		add_filter( 'plugin_action_links_' . plugin_basename( WACU_PLUGIN_FILE ), array( $this, 'plugin_page_settings_link' ) );
		add_action( 'init', array( new self, 'register_post_type' ) );
		add_action( 'init', array( $this, 'upgrader_process_complete' ), 10, 2 );
	}

	function load_files() {
		require_once WACU_PLUGIN_PATH . 'includes/wacu-functions.php';
		require_once WACU_PLUGIN_PATH . 'includes/class-wacu-icon.php';
		require_once WACU_PLUGIN_PATH . 'includes/wacu-social-contact-functions.php';
		require_once WACU_PLUGIN_PATH . 'includes/wacu-smart-message-functions.php';
		require_once WACU_PLUGIN_PATH . 'includes/class-wacu-schedule-call.php';
		require_once WACU_PLUGIN_PATH . 'includes/class-wacu-email-us.php';
		require_once WACU_PLUGIN_PATH . 'includes/wacu-dropdown-functions.php';


		if ( is_admin() ) {
			require_once WACU_PLUGIN_PATH . 'includes/admin/wacu-admin-functions.php';
			require_once WACU_PLUGIN_PATH . 'includes/admin/class-wacu-admin-settings.php';
			require_once WACU_PLUGIN_PATH . 'includes/admin/class-wacu-admin-init.php';
			require_once WACU_PLUGIN_PATH . 'includes/admin/class-wacu-admin-enqueue.php';
			require_once WACU_PLUGIN_PATH . 'includes/admin/class-wacu-admin-save-settings.php';
			require_once WACU_PLUGIN_PATH . 'includes/admin/class-wacu-admin-notice.php';
			require_once WACU_PLUGIN_PATH . 'includes/admin/class-wacu-admin-plugin-updater.php';
		} else {
			require_once WACU_PLUGIN_PATH . 'includes/class-wacu-gdpr.php';
			require_once WACU_PLUGIN_PATH . 'includes/class-wacu-enqueue.php';
			require_once WACU_PLUGIN_PATH . 'includes/class-wacu-shortcode.php';
			require_once WACU_PLUGIN_PATH . 'includes/class-wacu-widget.php';
			require_once WACU_PLUGIN_PATH . 'includes/class-wacu-buttons.php';
		}
			// Integrations
			require_once WACU_PLUGIN_PATH . 'includes/integration/class-wacu-integration-fcc.php';
			require_once WACU_PLUGIN_PATH . 'includes/integration/class-wacu-integration-tawk-to.php';
			require_once WACU_PLUGIN_PATH . 'includes/integration/class-wacu-integration-wordpress-whatsapp-support.php';

		// Deprecations
		require_once WACU_PLUGIN_PATH . 'includes/deprecated/wacu-deprecated-functions.php';
		require_once WACU_PLUGIN_PATH . 'includes/deprecated/wacu-deprecated-shortcodes.php';
	}

	public static function register_post_type() {
		register_post_type(
			'wacu_smart_message',
			array(
				'public'             => false,
				'label'              => __( 'Smart Message', 'wp-any-contact-us' ),
				'show_in_menu'       => false,
				'show_ui'            => false,
				'publicly_queryable' => false,
			)
		);
		register_post_type(
			'wacu_social_contact',
			array(
				'public'             => false,
				'label'              => __( 'Social Contact', 'wp-any-contact-us' ),
				'show_in_menu'       => false,
				'show_ui'            => false,
				'publicly_queryable' => false,
			)
		);
	}

	/**
	 * Load Localisation files.
	 */
	public function load_plugin_textdomain() {
		load_plugin_textdomain(
			'wp-any-contact-us',
			false,
			plugin_basename( dirname( WACU_PLUGIN_FILE ) ) . '/languages' );
	}

	/**
	 * Adding a Settings link to plugin
	 */
	public function plugin_page_settings_link( $links ) {
		$links[] = '<a href="' .
			admin_url( 'admin.php?page=wp-any-contact-us' ) .
			'">' . esc_html__( 'Settings', 'wp-any-contact-us' ) . '</a>';
		return $links;
	}

	/**
	 * This function runs when plugin update.
	 */
	public function upgrader_process_complete() {
		if ( get_option( 'wacu_version' ) != WACU_PLUGIN_VER ) {
			wacu_plugin_installation();
			// update current version.
			update_option( 'wacu_version', WACU_PLUGIN_VER );
		}
	}
}
