<?php
defined( 'ABSPATH' ) || exit;

class WACU_Shortcode {

	public function __construct() {
		add_shortcode( 'wacu_popup_trigger', array( $this, 'popup_trigger' ) );
	}

	public function popup_trigger( $atts ) {
		$a = shortcode_atts( array(
			'id'         => '',
			'text'       => 'Display',
			'bg_color'   => '#606ccb',
			'text_color' => '#ffffff',
			'font_size'  => '16px',
		), $atts );

		$style = 'style="background-color: ' . esc_attr( $a['bg_color'] ) . '; color: ' . esc_attr( $a['text_color'] ) . '; font-size: ' . esc_attr( $a['font_size'] ) . ';"';

		return sprintf(
			/* %1$s ID attribute */
			/* %2$s Inline style */
			/* %3$s Button text */
			'<a href="javascript:;" %1$s class="wacu-shortcode-trigger-btn" %2$s data-wacu-popup-trigger>%3$s</a>',
			( $a['id'] ) ? esc_attr( $a['id'] ) : '',
			$style, // WPCS: XSS ok.
			esc_html( $a['text'] )
		);
	}

}

$wacu_shortcode = new WACU_Shortcode;
