<?php
defined( 'ABSPATH' ) || exit;

/**
 * Smart message template variables.
 *
 * @since 1.1
 * @param string $replaced_subject  Replaced subject or string.
 * @param array  $search            Array of search template variables.
 * @param string $replace           Array of replace functions.
 * @param string $subject           The string thet need to be convert.
 */
function wacu_deprecated_smart_message_variables( $replaced_subject, $search, $replace, $subject ) {
	$search[]  = '{{product_name}}';
	$replace[] = get_the_title();

	return str_replace( $search, $replace, $replaced_subject );
}
add_filter( 'wacu_template_variables', 'wacu_deprecated_smart_message_variables', 20, 4 );
