<?php
defined( 'ABSPATH' ) || exit;

class WACU_Integration_FCC {

	public function __construct() {
		if ( ! wacu_is_widget_display() ) {
			return;
		}
		if ( 'yes' !== wacu_integration_option( 'facebook_customer_chat', 'status' ) ) {
			return;
		}

		add_action( 'wp_footer', array( $this, 'output' ), 50 );
		add_action( 'wp_enqueue_scripts', array( $this, 'inline_css' ), 230 );
	}

	public function output() {
		$page_id            = wacu_integration_option( 'facebook_customer_chat', 'page_id' );
		$background_color   = wacu_integration_option( 'facebook_customer_chat', 'background_color' );
		?>
			<div id="wacu-fcc" class="wacu-hide">
				<div id='fb-root'></div>
				<script>
					(function(d, s, id) {
						var js, fjs = d.getElementsByTagName(s)[0];

						js = d.createElement(s); js.id = id;
						js.src = 'https://connect.facebook.net/en_US/sdk/xfbml.customerchat.js#xfbml=1&version=v2.12&autoLogAppEvents=1';
						fjs.parentNode.insertBefore(js, fjs);
					}(document, 'script', 'facebook-jssdk'));
				</script>
				<div
					class="fb-customerchat"
					page_id="<?php echo esc_attr( $page_id ); ?>"
					attribution="setup_tool"
					greeting_dialog_display="hide"
					theme_color="<?php echo esc_attr( $background_color ); ?>">
				</div>
			</div>
		<?php
	}

	public function inline_css() {
		$trigger_offset_x = wacu_appearance_option( 'trigger_offset_x' );
		$trigger_offset_y = wacu_appearance_option( 'trigger_offset_y' );
		$widget_location  = wacu_appearance_option( 'widget_location' );

		$css = '
		.fb_customer_chat_bubble_animated_no_badge {
			bottom: ' . absint( $trigger_offset_y ) . 'px !important;
		}
		.fb-customerchat > span > iframe {
			bottom: ' . absint( $trigger_offset_y + 60 ) . 'px !important;
		}
		';

		if ( 'bl' === $widget_location ) {
			$css .= '
			.fb_customer_chat_bubble_animated_no_badge {
				left: ' . absint( $trigger_offset_x ) . 'px !important;
			}
			';
			if ( ! wp_is_mobile() ) {
				$css .= '
				.fb-customerchat > span > iframe {
					left: ' . absint( $trigger_offset_x ) . 'px !important;
					right: auto !important;
				}
				';
			}
		} else {
			$css .= '
			.fb_customer_chat_bubble_animated_no_badge {
				right: ' . absint( $trigger_offset_x ) . 'px !important;
			}
			';
			if ( ! wp_is_mobile() ) {
				$css .= '
				.fb-customerchat > span > iframe {
					right: ' . absint( $trigger_offset_x ) . 'px !important;
					left: auto !important;
				}
				';
			}
		}

		wp_add_inline_style( 'wacu-style', $css );
	}

}

function wacu_integration_fcc() {
	new WACU_Integration_FCC;
}
add_action( 'wp', 'wacu_integration_fcc' );
