<?php
defined( 'ABSPATH' ) || exit;

/**
 * Upgrade plugin for 1.1
 */
function wacu_plugin_upgrade_1_1() {
	// If previous installed vesion was 1.0.8 < 1.1
	if ( get_option( 'wacu_appearance' ) ) {
		$appearance_option     = get_option( 'wacu_appearance' );
		$basic_option          = get_option( 'wacu_basic_setting' );
		$smart_popup_option    = get_option( 'wacu_smart_popup' );
		$contact_medium_option = get_option( 'wacu_contact_medium' );
		$gdpr_option           = get_option( 'wacu_gdpr_setting' );
		$social_medias         = get_option( 'wacu_social_media' );

		// Appearance: Button Icon
		if ( 'wacu-fa wacu-fa-envelope' === $appearance_option['button_icon'] ) {
			$appearance_option['button_icon'] = 'envelope';
		} else if ( 'wacu-fa wacu-fa-phone' === $appearance_option['button_icon'] ) {
			$appearance_option['button_icon'] = 'phone-alt';
		} else if ( 'wacu-fa wacu-fa-whatsapp' === $appearance_option['button_icon'] ) {
			$appearance_option['button_icon'] = 'whatsapp';
		} else if ( 'wacu-fa wacu-fa-skype' === $appearance_option['button_icon'] ) {
			$appearance_option['button_icon'] = 'skype';
		} else if ( 'wacu-fa wacu-fa-telegram' === $appearance_option['button_icon'] ) {
			$appearance_option['button_icon'] = 'telegram-plane';
		} else {
			$appearance_option['button_icon'] = 'comments';
		}

		update_option(
			'wacu_appearance_settings',
			array(
				'background_color' => $appearance_option['bg_color'],
				'text_color'       => $appearance_option['text_color'],
				'widget_location'  => $appearance_option['location'],
				'trigger_size'     => $appearance_option['button_size'],
				'trigger_offset_x' => $appearance_option['button_offset'],
				'trigger_offset_y' => $appearance_option['button_offset'],
				'trigger_icon'     => $appearance_option['button_icon'],
			)
		);
		update_option(
			'wacu_basic_settings',
			array(
				'filter_by_everywhere'    => ( '1' == $basic_option['display_everywhere'] ) ? 'yes' : 'no',
				'filter_include_by_page'  => (array) $basic_option['display_by_page'],
				'filter_by_regester_user' => ( '1' == $basic_option['display_by_register_users'] ) ? 'yes' : 'no',
				'rtl'                     => ( '1' == $appearance_option['rtl'] ) ? 'yes' : 'no',
				'custom_css'              => $basic_option['custom_css'],
			)
		);
		update_option(
			'wacu_text_settings',
			array(
				'header_text' => $appearance_option['header_text'],
			)
		);
		update_option(
			'wacu_smart_popup_settings',
			array(
				'status'   => ( '1' == $smart_popup_option['is_popup'] ) ? 'yes' : 'no',
				'delay'    => $smart_popup_option['popup_after'],
				'interval' => $smart_popup_option['popup_interval'],
			)
		);
		update_option(
			'wacu_email_us_settings',
			array(
				'label_full_name'     => $contact_medium_option['email']['label']['full_name'],
				'label_email_address' => $contact_medium_option['email']['label']['email_address'],
				'label_email_message' => $contact_medium_option['email']['label']['message'],
				'label_button'        => $contact_medium_option['email']['label']['button'],
				'email_subject'       => $contact_medium_option['email']['email']['subject'],
				'email_body'          => $contact_medium_option['email']['email']['body'],
				'email_to'            => $contact_medium_option['email']['email']['to'],
				'email_from_name'     => $contact_medium_option['email']['email']['from_name'],
				'email_from_email'    => $contact_medium_option['email']['email']['from_email'],
				'thank_you_message'   => $contact_medium_option['email']['thank_you_message'],
			)
		);
		update_option(
			'wacu_schedule_call_settings',
			array(
				'field_country'         => ( '1' == $contact_medium_option['schedule_a_call']['field']['country'] ) ? 'yes' : 'no',
				'field_schedule_time'   => ( '1' == $contact_medium_option['schedule_a_call']['field']['schedule_time'] ) ? 'yes' : 'no',
				'field_message'         => ( '1' == $contact_medium_option['schedule_a_call']['field']['message'] ) ? 'yes' : 'no',
				'label_full_name'       => $contact_medium_option['schedule_a_call']['label']['full_name'],
				'label_country'         => $contact_medium_option['schedule_a_call']['label']['country'],
				'label_callback_number' => $contact_medium_option['schedule_a_call']['label']['callback_number'],
				'label_schedule_time'   => $contact_medium_option['schedule_a_call']['label']['schedule_time'],
				'label_message'         => $contact_medium_option['schedule_a_call']['label']['message'],
				'label_button'          => $contact_medium_option['schedule_a_call']['label']['button'],
				'email_subject'         => $contact_medium_option['schedule_a_call']['email']['subject'],
				'email_body'            => $contact_medium_option['schedule_a_call']['email']['body'],
				'email_to'              => $contact_medium_option['schedule_a_call']['email']['to'],
				'email_from_name'       => $contact_medium_option['schedule_a_call']['email']['from_name'],
				'email_from_email'      => $contact_medium_option['schedule_a_call']['email']['from_email'],
				'thank_you_message'     => $contact_medium_option['schedule_a_call']['thank_you_message'],
			)
		);
		update_option(
			'wacu_gdpr_settings',
			array(
				'status'       => ( '1' == $gdpr_option['is_gdpr'] ) ? 'yes' : 'no',
				'message'      => $gdpr_option['message'],
				'privacy_page' => $gdpr_option['privacy_page'],
			)
		);

		// Smart messages post insert
		$sm_post_1 = wp_insert_post(
			array(
				'post_title'   => 'Smart Message',
				'post_content' => $smart_popup_option['text']['default'],
				'post_status'  => 'publish',
				'post_type'    => 'wacu_smart_message',
				'post_author'  => get_current_user_id(),
			)
		);
		add_post_meta( $sm_post_1, 'post_type', '0', true );
		add_post_meta( $sm_post_1, 'status', '1', true );
		add_post_meta( $sm_post_1, 'position', '1', true );

		$sm_post_2 = wp_insert_post(
			array(
				'post_title'   => 'Smart Message',
				'post_content' => $smart_popup_option['text']['woo_product'],
				'post_status'  => 'publish',
				'post_type'    => 'wacu_smart_message',
				'post_author'  => get_current_user_id(),
			)
		);
		add_post_meta( $sm_post_2, 'post_type', 'product', true );
		add_post_meta( $sm_post_2, 'status', '1', true );
		add_post_meta( $sm_post_2, 'position', '2', true );

		// Social contacts insert post
		# schedule call
		if ( '1' == $basic_option['contact']['schedule_a_call'] ) {
			$sc_schdule_call_post = wp_insert_post(
				array(
					'post_title'   => $contact_medium_option['schedule_a_call']['label']['label'],
					'post_content' => $contact_medium_option['schedule_a_call']['desc'],
					'post_status'  => 'publish',
					'post_type'    => 'wacu_social_contact',
					'post_author'  => get_current_user_id(),
				)
			);

			add_post_meta( $sc_schdule_call_post, 'icon', 'envelope', true );
			add_post_meta( $sc_schdule_call_post, 'icon_color', '#FF4444', true );
			add_post_meta( $sc_schdule_call_post, 'device', '3', true );
			add_post_meta( $sc_schdule_call_post, 'register_only', '0', true );
			add_post_meta( $sc_schdule_call_post, 'type', '2', true );
			add_post_meta( $sc_schdule_call_post, 'link', '', true );
			add_post_meta( $sc_schdule_call_post, 'target', '_self', true );
			add_post_meta( $sc_schdule_call_post, 'content', '[wacu_schedule_call]', true );
			add_post_meta( $sc_schdule_call_post, 'integration', '0', true );
			add_post_meta( $sc_schdule_call_post, 'status', '1', true );
			add_post_meta( $sc_schdule_call_post, 'position', '1', true );
		}
		# email us
		if ( '1' == $basic_option['contact']['email'] ) {
			$sc_email_us_post = wp_insert_post(
				array(
					'post_title'   => $contact_medium_option['email']['label']['label'],
					'post_content' => $contact_medium_option['email']['desc'],
					'post_status'  => 'publish',
					'post_type'    => 'wacu_social_contact',
					'post_author'  => get_current_user_id(),
				)
			);

			add_post_meta( $sc_email_us_post, 'icon', 'phone-alt', true );
			add_post_meta( $sc_email_us_post, 'icon_color', '#4185F2', true );
			add_post_meta( $sc_email_us_post, 'device', '3', true );
			add_post_meta( $sc_email_us_post, 'register_only', '0', true );
			add_post_meta( $sc_email_us_post, 'type', '2', true );
			add_post_meta( $sc_email_us_post, 'link', '', true );
			add_post_meta( $sc_email_us_post, 'target', '_self', true );
			add_post_meta( $sc_email_us_post, 'content', '[wacu_email_us]', true );
			add_post_meta( $sc_email_us_post, 'integration', '0', true );
			add_post_meta( $sc_email_us_post, 'status', '1', true );
			add_post_meta( $sc_email_us_post, 'position', '1', true );
		}

		if ( $social_medias ) {
			foreach ( $social_medias as $social_media ) {
				$post_id = wp_insert_post(
					array(
						'post_title'   => $social_media['title'],
						'post_content' => $social_media['desc'],
						'post_status'  => 'publish',
						'post_type'    => 'wacu_social_contact',
						'post_author'  => get_current_user_id(),
					)
				);

				// Behance
				if ( 'behance' === $social_media['social_media'] ) {
					add_post_meta( $post_id, 'icon', 'behance', true );
					add_post_meta( $post_id, 'icon_color', '#131418', true );
					add_post_meta( $post_id, 'link', "https://www.behance.net/{$social_media['username']}", true );
				}
				// Call Us
				if ( 'call_us' === $social_media['social_media'] ) {
					add_post_meta( $post_id, 'icon', 'phone-volume', true );
					add_post_meta( $post_id, 'icon_color', '#e91e63', true );
					add_post_meta( $post_id, 'link', "tel:{$social_media['number']}", true );
				}
				// Dribbble
				if ( 'dribbble' === $social_media['social_media'] ) {
					add_post_meta( $post_id, 'icon', 'dribbble', true );
					add_post_meta( $post_id, 'icon_color', '#ea4c89', true );
					add_post_meta( $post_id, 'link', "https://dribbble.com/{$social_media['username']}", true );
				}
				// Facebook Messenge
				if ( 'fb_messenger' === $social_media['social_media'] ) {
					add_post_meta( $post_id, 'icon', 'facebook-messenger', true );
					add_post_meta( $post_id, 'icon_color', '#0084FF', true );
					add_post_meta( $post_id, 'link', "https://m.me/{$social_media['username']}", true );
				}
				// Instagaram
				if ( 'instagram' === $social_media['social_media'] ) {
					add_post_meta( $post_id, 'icon', 'instagram', true );
					add_post_meta( $post_id, 'icon_color', '#e4405f', true );
					add_post_meta( $post_id, 'link', "https://instagram.com/{$social_media['username']}", true );
				}
				// Linkedin
				if ( 'linkedin' === $social_media['social_media'] ) {
					add_post_meta( $post_id, 'icon', 'linkedin-in', true );
					add_post_meta( $post_id, 'icon_color', '#0077B5', true );
					add_post_meta( $post_id, 'link', "https://www.linkedin.com/in/{$social_media['username']}", true );
				}
				// Skype
				if ( 'skype' === $social_media['social_media'] ) {
					add_post_meta( $post_id, 'icon', 'skype', true );
					add_post_meta( $post_id, 'icon_color', '#00AFF0', true );
					add_post_meta( $post_id, 'link', "skype://{$social_media['username']}?chat", true );
				}
				// Telegram
				if ( 'telegram' === $social_media['social_media'] ) {
					add_post_meta( $post_id, 'icon', 'telegram-plane', true );
					add_post_meta( $post_id, 'icon_color', '#39AFE2', true );
					add_post_meta( $post_id, 'link', "https://t.me/{$social_media['username']}", true );
				}
				// Twitter
				if ( 'twitter' === $social_media['social_media'] ) {
					add_post_meta( $post_id, 'icon', 'twitter', true );
					add_post_meta( $post_id, 'icon_color', '#55acee', true );
					add_post_meta( $post_id, 'link', "https://twitter.com/{$social_media['username']}", true );
				}
				// WhatsApp
				if ( 'whatsapp' === $social_media['social_media'] ) {
					add_post_meta( $post_id, 'icon', 'whatsapp', true );
					add_post_meta( $post_id, 'icon_color', '#25D366', true );
					add_post_meta( $post_id, 'link', "https://api.whatsapp.com/send?phone={$social_media['number']}", true );
				}
				// VK
				if ( 'vk' === $social_media['social_media'] ) {
					add_post_meta( $post_id, 'icon', 'vk', true );
					add_post_meta( $post_id, 'icon_color', '#4c75a3', true );
					add_post_meta( $post_id, 'link', "https://vk.com/{$social_media['username']}", true );
				}

				add_post_meta( $post_id, 'device', '3', true );
				add_post_meta( $post_id, 'register_only', '0', true );
				add_post_meta( $post_id, 'type', '1', true );
				add_post_meta( $post_id, 'target', '_blank', true );
				add_post_meta( $post_id, 'content', '', true );
				add_post_meta( $post_id, 'integration', '0', true );
				add_post_meta( $post_id, 'status', '1', true );
				add_post_meta( $post_id, 'position', '1', true );
			}
		}

		delete_transient( 'wacu_social_contacts' );
		delete_option( 'wacu_appearance' );
	} // endif;
}
