<?php
/**
 * WordPress Any Contact Us
 *
 * @author      WeCreativez
 * @copyright   2020 WeCreativez
 * @license     GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name:       WordPress Any Contact Us
 * Plugin URI:        https://codecanyon.net/item/wordpress-any-contact-us/23280292/
 * Description:       Increase your revenue by connecting with clients where they are :)
 * Version:           2.1.1
 * Requires at least: 4.5
 * Requires PHP:      5.6
 * Author:            WeCreativez
 * Author URI:        http://wecreativez.com/
 * Text Domain:       wp-any-contact-us
 * License:           GPL v2 or later
 * Domain Path:       /languages/
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

defined( 'ABSPATH' ) || exit;

if ( ! defined( 'WACU_PLUGIN_ENV' ) ) {
	/**
	 * Plugin environment.
	 * 1: development
	 * 2: production
	 */
	define( 'WACU_PLUGIN_ENV', 'production' );
}
if ( ! defined( 'WACU_PLUGIN_FILE' ) ) {
	define( 'WACU_PLUGIN_FILE', __FILE__ );
}
if ( ! defined( 'WACU_PLUGIN_PATH' ) ) {
	define( 'WACU_PLUGIN_PATH', plugin_dir_path( WACU_PLUGIN_FILE ) );
}
if ( ! defined( 'WACU_PLUGIN_URL' ) ) {
	define( 'WACU_PLUGIN_URL', plugin_dir_url( WACU_PLUGIN_FILE ) );
}
if ( ! defined( 'WACU_PLUGIN_VER' ) ) {
	if ( 'development' === WACU_PLUGIN_ENV ) {
		define( 'WACU_PLUGIN_VER', uniqid() );
	} else {
		define( 'WACU_PLUGIN_VER', '2.1.1' );
	}
}
if ( ! defined( 'WACU_PLUGIN_PREFIX' ) ) {
	define( 'WACU_PLUGIN_PREFIX', 'wacu_' );
}

if ( ! function_exists( 'wacu_plugin_installation' ) ) {
	/**
	 * Plugin installation.
	 */
	function wacu_plugin_installation() {
		// Upgrade init.
		require_once WACU_PLUGIN_PATH . 'includes/upgrade/wacu-upgrade-init.php';

		require_once WACU_PLUGIN_PATH . 'includes/class-wacu-install.php';

		WACU_Install::install();
	}
	register_activation_hook( WACU_PLUGIN_FILE, 'wacu_plugin_installation' );
}

if ( ! function_exists( 'wacu_plugin_initialize' ) ) {
	/**
	 * Initialization the plugin.
	 */
	function wacu_plugin_initialize() {
		require_once WACU_PLUGIN_PATH . 'includes/class-wacu-init.php';

		$wacu_init = new WACU_Init;
		return $wacu_init->init();
	}
	add_action( 'plugins_loaded', 'wacu_plugin_initialize', 20 );
}
